/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.cache.Graph;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.GraphBackgroundTask;
import org.tigris.subversion.subclipse.graph.editors.GraphEditPart;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.graph.popup.actions.ImageAction;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class GraphActionBarContributor
extends ActionBarContributor {
    private RevisionGraphEditor editor;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private static ToggleShowDeletedAction[] toggleShowDeletedActions;
    private static RefreshAction[] refreshActions;

    public void setActiveEditor(IEditorPart editor) {
        super.setActiveEditor(editor);
        this.editor = (RevisionGraphEditor)editor;
    }

    protected void buildActions() {
    }

    protected void declareGlobalActionKeys() {
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new ZoomComboContributionItem((IPartService)this.getPage()));
        toolBarManager.add((IContributionItem)new Separator());
        refreshActions = new RefreshAction[]{new RefreshAction("All new revisions", 0), new RefreshAction("Graph revisions", 1), new RefreshAction("New revisions and graph revisions", 2)};
        RefreshMenuAction refreshAction = new RefreshMenuAction();
        toolBarManager.add((IAction)refreshAction);
        toggleShowDeletedActions = new ToggleShowDeletedAction[]{new ToggleShowDeletedAction("If modified", 0), new ToggleShowDeletedAction("Yes", 1), new ToggleShowDeletedAction("No", 2)};
        ShowDeletedAction showDeletedAction = new ShowDeletedAction();
        toolBarManager.add((IAction)showDeletedAction);
        Action filterConnectionsAction = new Action(){

            public void run() {
                GraphActionBarContributor.this.store.setValue("RevisionGraph_filterConnections", this.isChecked());
                GraphEditPart graphEditPart = (GraphEditPart)GraphActionBarContributor.this.editor.getViewer().getContents();
                graphEditPart.setConnectionVisibility();
            }
        };
        filterConnectionsAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("filter_connections.gif"));
        filterConnectionsAction.setToolTipText("Show connections only for selected revision");
        filterConnectionsAction.setChecked(this.store.getBoolean("RevisionGraph_filterConnections"));
        toolBarManager.add((IAction)filterConnectionsAction);
        Action chronologicalAction = new Action(){

            public void run() {
                GraphActionBarContributor.this.store.setValue("RevisionGraph_chronological", this.isChecked());
                GraphEditPart graphEditPart = (GraphEditPart)GraphActionBarContributor.this.editor.getViewer().getContents();
                Graph graph = (Graph)graphEditPart.getModel();
                GraphActionBarContributor.this.editor.getViewer().setContents((Object)"Redrawing graph...");
                GraphActionBarContributor.this.editor.getViewer().setContents((Object)graph);
            }
        };
        chronologicalAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("revision_graph_chronological.gif"));
        chronologicalAction.setToolTipText("Chronological layout");
        chronologicalAction.setChecked(this.store.getBoolean("RevisionGraph_chronological"));
        toolBarManager.add((IAction)chronologicalAction);
        Action imageAction = new Action(){

            public void run() {
                ImageAction action = new ImageAction(GraphActionBarContributor.this.editor);
                action.run();
            }
        };
        imageAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("export_image.gif"));
        toolBarManager.add((IAction)imageAction);
    }

    public class RefreshAction
    extends Action {
        private final int type;
        public static final int TYPE_NEW = 0;
        public static final int TYPE_NODES = 1;
        public static final int TYPE_BOTH = 2;

        public RefreshAction(String text, int type) {
            super(text);
            this.type = type;
        }

        public void run() {
            SVNRevision[] refreshRevisions = null;
            Node[] nodes = null;
            if (this.type == 1 || this.type == 2) {
                ArrayList<SVNRevision.Number> refreshList = new ArrayList<SVNRevision.Number>();
                GraphEditPart graphEditPart = (GraphEditPart)GraphActionBarContributor.this.editor.getViewer().getContents();
                Graph graph = (Graph)graphEditPart.getModel();
                nodes = graph.getNodes();
                int i = 0;
                while (i < nodes.length) {
                    SVNRevision.Number revision = new SVNRevision.Number(nodes[i].getRevision());
                    refreshList.add(revision);
                    ++i;
                }
                refreshRevisions = new SVNRevision[refreshList.size()];
                refreshList.toArray(refreshRevisions);
            }
            IResource resource = ((RevisionGraphEditorInput)GraphActionBarContributor.this.editor.getEditorInput()).getResource();
            ISVNRemoteResource remoteResource = ((RevisionGraphEditorInput)GraphActionBarContributor.this.editor.getEditorInput()).getRemoteResource();
            GraphBackgroundTask task = resource == null ? new GraphBackgroundTask(SVNUIPlugin.getActivePage().getActivePart(), GraphActionBarContributor.this.editor.getViewer(), GraphActionBarContributor.this.editor, remoteResource) : new GraphBackgroundTask(SVNUIPlugin.getActivePage().getActivePart(), GraphActionBarContributor.this.editor.getViewer(), GraphActionBarContributor.this.editor, resource);
            if (this.type == 1) {
                task.setGetNewRevisions(false);
            }
            if (refreshRevisions != null) {
                task.setRefreshRevisions(refreshRevisions, nodes);
            }
            try {
                task.run();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)("Refresh " + this.getText()), (String)e.getMessage());
            }
        }
    }

    public static class RefreshMenuAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public RefreshMenuAction() {
            this.setText("Refresh");
            this.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/refresh.gif"));
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            this.addActionToMenu(this.menu, refreshActions[0]);
            this.addActionToMenu(this.menu, refreshActions[1]);
            this.addActionToMenu(this.menu, refreshActions[2]);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    public static class ShowDeletedAction
    extends Action
    implements IMenuCreator {
        private Menu menu;

        public ShowDeletedAction() {
            this.setText("Show deleted branches");
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("show_deleted.gif"));
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            this.addActionToMenu(this.menu, toggleShowDeletedActions[0]);
            this.addActionToMenu(this.menu, toggleShowDeletedActions[1]);
            this.addActionToMenu(this.menu, toggleShowDeletedActions[2]);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }
    }

    public class ToggleShowDeletedAction
    extends Action {
        private final int show;

        public ToggleShowDeletedAction(String text, int show) {
            super(text, 8);
            this.show = show;
            this.setChecked(show == GraphActionBarContributor.this.store.getInt("RevisionGraph_showDeleted"));
        }

        public int getShow() {
            return this.show;
        }

        public void run() {
            if (this.isChecked()) {
                Activator.getDefault().getPreferenceStore().setValue("RevisionGraph_showDeleted", this.show);
                GraphEditPart graphEditPart = (GraphEditPart)GraphActionBarContributor.this.editor.getViewer().getContents();
                Graph graph = (Graph)graphEditPart.getModel();
                GraphActionBarContributor.this.editor.getViewer().setContents((Object)"Redrawing graph...");
                GraphActionBarContributor.this.editor.getViewer().setContents((Object)graph);
            }
        }
    }
}

