/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.dialogs;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditor;

public class SaveImageDialog
extends TrayDialog {
    private RevisionGraphEditor editor;
    private Combo fileTypeCombo;
    private Text fileText;
    private Button browseButton;
    private int lastOutput;
    private IDialogSettings settings = Activator.getDefault().getDialogSettings();
    private Button okButton;
    private static final int BMP = 0;
    private static final int JPEG = 1;
    private static final int PNG = 2;
    private static final String LAST_OUTPUT = "SaveImageDialog.lastOutput";

    public SaveImageDialog(Shell parentShell, RevisionGraphEditor editor) {
        super(parentShell);
        this.editor = editor;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        try {
            this.lastOutput = this.settings.getInt(LAST_OUTPUT);
        }
        catch (Exception exception) {}
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Save Image to File");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText("Save as file type:");
        this.fileTypeCombo = new Combo(composite, 8);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fileTypeCombo.setLayoutData((Object)gd);
        this.fileTypeCombo.add("BMP");
        this.fileTypeCombo.add("JPEG");
        this.fileTypeCombo.add("PNG");
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText("Save to file:");
        this.fileText = new Text(composite, 2048);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.fileText.setLayoutData((Object)gd);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SaveImageDialog.this.selectFile();
            }
        });
        switch (this.lastOutput) {
            case 0: {
                this.fileTypeCombo.setText("BMP");
                break;
            }
            case 1: {
                this.fileTypeCombo.setText("JPEG");
                break;
            }
            case 2: {
                this.fileTypeCombo.setText("PNG");
                break;
            }
            default: {
                this.fileTypeCombo.setText("BMP");
            }
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveImageDialog.this.okButton.setEnabled(SaveImageDialog.this.canFinish());
            }
        };
        this.fileText.addModifyListener(modifyListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fileText.addFocusListener((FocusListener)focusListener);
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    protected void okPressed() {
        this.settings.put(LAST_OUTPUT, this.fileTypeCombo.getSelectionIndex());
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                GraphicalViewer viewer = SaveImageDialog.this.editor.getViewer();
                ScalableRootEditPart rootEditPart = (ScalableRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
                IFigure rootFigure = rootEditPart.getLayer((Object)"Printable Layers");
                Rectangle rootFigureBounds = rootFigure.getBounds();
                Control figureCanvas = viewer.getControl();
                GC figureCanvasGC = new GC((Drawable)figureCanvas);
                Image img = new Image(null, rootFigureBounds.width, rootFigureBounds.height);
                GC imageGC = new GC((Drawable)img);
                imageGC.setBackground(figureCanvasGC.getBackground());
                imageGC.setForeground(figureCanvasGC.getForeground());
                imageGC.setFont(figureCanvasGC.getFont());
                imageGC.setLineStyle(figureCanvasGC.getLineStyle());
                imageGC.setLineWidth(figureCanvasGC.getLineWidth());
                SWTGraphics imgGraphics = new SWTGraphics(imageGC);
                rootFigure.paint((Graphics)imgGraphics);
                ImageData[] imgData = new ImageData[]{img.getImageData()};
                ImageLoader imgLoader = new ImageLoader();
                imgLoader.data = imgData;
                String extension = SaveImageDialog.this.fileTypeCombo.getText().equals("JPEG") ? "jpg" : SaveImageDialog.this.fileTypeCombo.getText().toLowerCase();
                String fileName = null;
                fileName = !SaveImageDialog.this.fileText.getText().trim().endsWith("." + extension) ? String.valueOf(SaveImageDialog.this.fileText.getText().trim()) + "." + extension : SaveImageDialog.this.fileText.getText().trim();
                int imageType = 0;
                switch (SaveImageDialog.this.fileTypeCombo.getSelectionIndex()) {
                    case 0: {
                        imageType = 0;
                        break;
                    }
                    case 1: {
                        imageType = 4;
                        break;
                    }
                    case 2: {
                        imageType = 5;
                        break;
                    }
                }
                imgLoader.save(fileName, imageType);
                figureCanvasGC.dispose();
                imageGC.dispose();
                img.dispose();
            }
        });
        super.okPressed();
    }

    private boolean canFinish() {
        if (this.fileText.getText().trim().length() == 0) {
            return false;
        }
        File file = new File(this.fileText.getText().trim());
        return this.isValidFile(file);
    }

    private boolean isValidFile(File file) {
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.exists()) {
            return false;
        }
        return parent.isDirectory();
    }

    private void selectFile() {
        String extension = this.fileTypeCombo.getText().equals("JPEG") ? "jpg" : this.fileTypeCombo.getText().toLowerCase();
        FileDialog d = new FileDialog(this.getShell(), 40960);
        d.setText("Save Revision Graph As");
        d.setFileName(String.valueOf(this.editor.getEditorInput().getName()) + "." + extension);
        String file = d.open();
        if (file != null) {
            Path path = new Path(file);
            this.fileText.setText(path.toOSString());
        }
    }
}

