/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.views;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.springframework.ide.eclipse.beans.ui.live.actions.OpenBeanClassAction;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansModelCollection;
import org.springframework.ide.eclipse.beans.ui.live.tree.ContextGroupedBeansContentProvider;
import org.springframework.ide.eclipse.beans.ui.live.tree.InnerBeansViewerFilter;
import org.springframework.ide.eclipse.beans.ui.live.tree.LiveBeansTreeLabelProvider;
import org.springframework.ide.eclipse.beans.ui.live.tree.ResourceGroupedBeansContentProvider;
import org.springframework.ide.eclipse.beans.ui.livegraph.LiveGraphUiPlugin;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.ConnectToApplicationAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.FilterInnerBeansAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.LoadModelAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.OpenXmlBeanDefinitionAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.RefreshApplicationAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.ToggleGroupByAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.ToggleViewModeAction;
import org.springframework.ide.eclipse.beans.ui.livegraph.views.ExtendedDirectedGraphLayoutAlgorithm;
import org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphContentProvider;
import org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphLabelProvider;

public class LiveBeansGraphView
extends ViewPart {
    public static final String VIEW_ID = "org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphView";
    public static final String PREF_DISPLAY_MODE = "org.springframework.ide.eclipse.beans.ui.livegraph.prefs.displayMode.LiveBeansGraphView";
    public static final String PREF_GROUP_MODE = "org.springframework.ide.eclipse.beans.ui.livegraph.prefs.groupByMode.LiveBeansGraphView";
    public static final String PREF_FILTER_INNER_BEANS = "org.springframework.ide.eclipse.beans.ui.livegraph.prefs.filterInnerBeans.LiveBeansGraphView";
    public static final int DISPLAY_MODE_GRAPH = 0;
    public static final int DISPLAY_MODE_TREE = 1;
    public static final int GROUP_BY_RESOURCE = 0;
    public static final int GROUP_BY_CONTEXT = 1;
    private ToggleViewModeAction[] displayModeActions;
    private ToggleGroupByAction[] groupByActions;
    private final MultiViewerSelectionProvider selectionProvider;
    private BaseSelectionListenerAction openBeanClassAction;
    private BaseSelectionListenerAction openBeanDefAction;
    private FilterInnerBeansAction filterInnerBeansAction;
    private final InnerBeansViewerFilter innerBeansFilter;
    private LiveBeansModel activeInput;
    private Action connectApplicationAction;
    private PageBook pagebook;
    private GraphViewer graphViewer;
    private TreeViewer treeViewer;
    private final IPreferenceStore prefStore = LiveGraphUiPlugin.getDefault().getPreferenceStore();
    private int activeDisplayMode;
    private int activeGroupByMode;

    public LiveBeansGraphView() {
        this.selectionProvider = new MultiViewerSelectionProvider();
        this.innerBeansFilter = new InnerBeansViewerFilter();
    }

    private void createGraphViewer() {
        this.graphViewer = new GraphViewer((Composite)this.pagebook, 0);
        this.graphViewer.setContentProvider((IContentProvider)new LiveBeansGraphContentProvider());
        this.graphViewer.setLabelProvider((IBaseLabelProvider)new LiveBeansGraphLabelProvider());
        this.graphViewer.setConnectionStyle(2);
        ExtendedDirectedGraphLayoutAlgorithm layout = new ExtendedDirectedGraphLayoutAlgorithm(257);
        this.graphViewer.setLayoutAlgorithm((LayoutAlgorithm)layout);
        this.graphViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LiveBeansGraphView.this.openBeanClassAction != null && LiveBeansGraphView.this.openBeanClassAction.isEnabled()) {
                    LiveBeansGraphView.this.openBeanClassAction.run();
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.makeActions();
        this.createGraphViewer();
        this.createTreeViewer();
        this.hookToolBar();
        this.hookPullDownMenu();
        this.hookContextMenu();
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openBeanClassAction);
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openBeanDefAction);
        this.setDisplayMode(this.prefStore.getInt(PREF_DISPLAY_MODE));
        this.setGroupByMode(this.prefStore.getInt(PREF_GROUP_MODE));
        this.setFilterInnerBeans(this.prefStore.getBoolean(PREF_FILTER_INNER_BEANS));
    }

    private ITreeContentProvider getTreeContentProvider() {
        if (this.getGroupByMode() == 1) {
            return ContextGroupedBeansContentProvider.INSTANCE;
        }
        if (this.getGroupByMode() == 0) {
            return ResourceGroupedBeansContentProvider.INSTANCE;
        }
        return null;
    }

    private void createTreeViewer() {
        this.treeViewer = new TreeViewer((Composite)this.pagebook, 0);
        this.treeViewer.setContentProvider((IContentProvider)this.getTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)LiveBeansTreeLabelProvider.INSTANCE);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LiveBeansGraphView.this.openBeanDefAction != null && LiveBeansGraphView.this.openBeanDefAction.isEnabled()) {
                    LiveBeansGraphView.this.openBeanDefAction.run();
                }
            }
        });
    }

    public void dispose() {
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openBeanClassAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openBeanDefAction);
        super.dispose();
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openBeanClassAction);
        menuManager.add((IAction)this.openBeanDefAction);
    }

    private void fillPullDownMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.connectApplicationAction);
        Set collection = LiveBeansModelCollection.getInstance().getCollection();
        if (collection.size() > 0) {
            menuManager.add((IContributionItem)new Separator());
        }
        for (LiveBeansModel model : collection) {
            menuManager.add((IAction)new LoadModelAction(this, model));
        }
        if (this.activeDisplayMode == 1) {
            menuManager.add((IContributionItem)new Separator());
            ToggleGroupByAction[] toggleGroupByActionArray = this.groupByActions;
            int n = this.groupByActions.length;
            int n2 = 0;
            while (n2 < n) {
                ToggleGroupByAction action = toggleGroupByActionArray[n2];
                menuManager.add((IAction)action);
                ++n2;
            }
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.filterInnerBeansAction);
    }

    public int getGroupByMode() {
        return this.activeGroupByMode;
    }

    public LiveBeansModel getInput() {
        return this.activeInput;
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.fillContextMenu((IMenuManager)menuManager);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = LiveBeansGraphView.this.getViewSite().getSelectionProvider().getSelection();
                if (!selection.isEmpty()) {
                    LiveBeansGraphView.this.fillContextMenu(manager);
                }
            }
        });
        this.graphViewer.getControl().setMenu(menuManager.createContextMenu(this.graphViewer.getControl()));
        this.treeViewer.getControl().setMenu(menuManager.createContextMenu(this.treeViewer.getControl()));
        this.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)this.selectionProvider);
    }

    private void hookPullDownMenu() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menuManager = bars.getMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.fillPullDownMenu(menuManager);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LiveBeansGraphView.this.fillPullDownMenu(manager);
            }
        });
    }

    private void hookToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        ToggleViewModeAction[] toggleViewModeActionArray = this.displayModeActions;
        int n = this.displayModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleViewModeAction displayModeAction = toggleViewModeActionArray[n2];
            toolbar.add((IAction)displayModeAction);
            ++n2;
        }
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)new RefreshApplicationAction(this));
    }

    private boolean isViewerVisible(Viewer viewer) {
        return viewer != null && !viewer.getControl().isDisposed() && viewer.getControl().isVisible();
    }

    private void makeActions() {
        this.openBeanClassAction = new OpenBeanClassAction();
        this.openBeanDefAction = new OpenXmlBeanDefinitionAction();
        this.connectApplicationAction = new ConnectToApplicationAction(this);
        this.displayModeActions = new ToggleViewModeAction[]{new ToggleViewModeAction(this, 0), new ToggleViewModeAction(this, 1)};
        this.groupByActions = new ToggleGroupByAction[]{new ToggleGroupByAction(this, 0), new ToggleGroupByAction(this, 1)};
        this.filterInnerBeansAction = new FilterInnerBeansAction(this);
    }

    public void setDisplayMode(int mode) {
        if (mode == 0) {
            this.pagebook.showPage(this.graphViewer.getControl());
        } else if (mode == 1) {
            this.pagebook.showPage(this.treeViewer.getControl());
        }
        ToggleViewModeAction[] toggleViewModeActionArray = this.displayModeActions;
        int n = this.displayModeActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleViewModeAction action;
            action.setChecked(mode == (action = toggleViewModeActionArray[n2]).getDisplayMode());
            ++n2;
        }
        this.activeDisplayMode = mode;
        this.prefStore.setValue(PREF_DISPLAY_MODE, mode);
    }

    public void setFocus() {
        if (this.isViewerVisible((Viewer)this.graphViewer)) {
            this.graphViewer.getControl().setFocus();
        } else if (this.isViewerVisible((Viewer)this.treeViewer)) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public void setGroupByMode(int mode) {
        this.activeGroupByMode = mode;
        this.treeViewer.setContentProvider((IContentProvider)this.getTreeContentProvider());
        ToggleGroupByAction[] toggleGroupByActionArray = this.groupByActions;
        int n = this.groupByActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleGroupByAction action;
            action.setChecked(mode == (action = toggleGroupByActionArray[n2]).getGroupByMode());
            ++n2;
        }
        this.prefStore.setValue(PREF_GROUP_MODE, mode);
    }

    public void setInput(LiveBeansModel model) {
        this.activeInput = model;
        if (this.graphViewer != null) {
            this.graphViewer.setInput((Object)this.activeInput);
        }
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.activeInput);
        }
    }

    public void setFilterInnerBeans(boolean filtered) {
        if (this.graphViewer != null) {
            if (filtered) {
                this.graphViewer.addFilter((ViewerFilter)this.innerBeansFilter);
            } else {
                this.graphViewer.removeFilter((ViewerFilter)this.innerBeansFilter);
            }
            this.graphViewer.applyLayout();
        }
        if (this.treeViewer != null) {
            if (filtered) {
                this.treeViewer.addFilter((ViewerFilter)this.innerBeansFilter);
            } else {
                this.treeViewer.removeFilter((ViewerFilter)this.innerBeansFilter);
            }
        }
        this.filterInnerBeansAction.setChecked(filtered);
        this.prefStore.setValue(PREF_FILTER_INNER_BEANS, filtered);
    }

    private class MultiViewerSelectionProvider
    implements ISelectionProvider {
        private MultiViewerSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (LiveBeansGraphView.this.graphViewer != null) {
                LiveBeansGraphView.this.graphViewer.addSelectionChangedListener(listener);
            }
            if (LiveBeansGraphView.this.treeViewer != null) {
                LiveBeansGraphView.this.treeViewer.addSelectionChangedListener(listener);
            }
        }

        public ISelection getSelection() {
            if (LiveBeansGraphView.this.isViewerVisible((Viewer)LiveBeansGraphView.this.graphViewer)) {
                return LiveBeansGraphView.this.graphViewer.getSelection();
            }
            if (LiveBeansGraphView.this.isViewerVisible((Viewer)LiveBeansGraphView.this.treeViewer)) {
                return LiveBeansGraphView.this.treeViewer.getSelection();
            }
            return null;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (LiveBeansGraphView.this.graphViewer != null) {
                LiveBeansGraphView.this.graphViewer.removeSelectionChangedListener(listener);
            }
            if (LiveBeansGraphView.this.treeViewer != null) {
                LiveBeansGraphView.this.treeViewer.removeSelectionChangedListener(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (LiveBeansGraphView.this.isViewerVisible((Viewer)LiveBeansGraphView.this.graphViewer)) {
                LiveBeansGraphView.this.graphViewer.setSelection(selection);
            } else if (LiveBeansGraphView.this.isViewerVisible((Viewer)LiveBeansGraphView.this.treeViewer)) {
                LiveBeansGraphView.this.treeViewer.setSelection(selection);
            }
        }
    }
}

