/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.json.JSONException;
import org.springframework.context.support.LiveBeansViewMBean;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansJsonParser;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansModelCollection;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansSession;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class LiveBeansModelGenerator {
    public static LiveBeansModel connectToModel(JMXConnector connector, LiveBeansSession session) throws CoreException {
        try {
            String appName = session.getApplicationName();
            if (connector != null) {
                ObjectName name = appName == null || appName.length() == 0 ? ObjectName.getInstance("", "application", "") : ObjectName.getInstance("", "application", "/".concat(appName));
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connection.getObjectInstance(name);
                LiveBeansViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, LiveBeansViewMBean.class, false);
                return LiveBeansModelGenerator.generateModel(mbean, session);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while connecting to server. Please check that the application name is correct.", (Throwable)e));
        }
        catch (InstanceNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while connecting to server. Please check that the application name is correct.", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while connecting to server.", (Throwable)e));
        }
        return null;
    }

    public static LiveBeansModel connectToModel(String serviceUrl, String username, String password, String appName) throws CoreException {
        return LiveBeansModelGenerator.connectToModel(serviceUrl, username, password, appName, null);
    }

    public static LiveBeansModel connectToModel(final String serviceUrl, final String username, final String password, final String appName, final IProject project) throws CoreException {
        final CountDownLatch latch = new CountDownLatch(1);
        final LiveBeansModel[] result = new LiveBeansModel[1];
        final CoreException[] status = new CoreException[1];
        Job jmxOperation = new Job("Executing Server Command"){

            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    JMXConnector connector = null;
                    try {
                        try {
                            connector = LiveBeansModelGenerator.setupConnector(serviceUrl, username, password);
                            result[0] = LiveBeansModelGenerator.connectToModel(connector, new LiveBeansSession(serviceUrl, username, password, appName, project));
                        }
                        catch (CoreException e) {
                            status[0] = e;
                            latch.countDown();
                            if (connector == null) break block12;
                            try {
                                connector.close();
                            }
                            catch (IOException e2) {
                                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while closing connection to server.", (Throwable)e2));
                            }
                        }
                    }
                    finally {
                        latch.countDown();
                        if (connector != null) {
                            try {
                                connector.close();
                            }
                            catch (IOException e) {
                                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while closing connection to server.", (Throwable)e));
                            }
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        jmxOperation.schedule();
        try {
            if (latch.await(30L, TimeUnit.SECONDS)) {
                if (status[0] != null) {
                    throw status[0];
                }
                return result[0];
            }
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private static LiveBeansModel generateModel(LiveBeansViewMBean mbean, LiveBeansSession session) throws CoreException {
        try {
            if (mbean != null) {
                String json = mbean.getSnapshotAsJson();
                LiveBeansJsonParser parser = new LiveBeansJsonParser((TypeLookup)session, json);
                LiveBeansModel model = parser.parse();
                LiveBeansModelCollection.getInstance().addModel(model);
                return model;
            }
        }
        catch (JSONException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while generating graph model.", (Throwable)e));
        }
        return null;
    }

    public static LiveBeansModel refreshModel(LiveBeansModel originalModel) throws CoreException {
        LiveBeansSession session;
        LiveBeansModel model;
        if (originalModel.getWorkspaceContext() instanceof LiveBeansSession && (model = LiveBeansModelGenerator.connectToModel((session = (LiveBeansSession)originalModel.getWorkspaceContext()).getServiceUrl(), session.getUsername(), session.getPassword(), session.getApplicationName(), session.getProject())) != null) {
            return model;
        }
        return originalModel;
    }

    private static JMXConnector setupConnector(String serviceUrl, String username, String password) throws CoreException {
        try {
            if (serviceUrl != null && serviceUrl.length() > 0) {
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                if (username != null && password != null) {
                    String[] creds = new String[]{username, password};
                    env.put("jmx.remote.credentials", creds);
                }
                return JMXConnectorFactory.connect(new JMXServiceURL(serviceUrl), env);
            }
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while connecting to server. Please check that the service URL is correct.", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.livegraph", "An error occurred while connecting to server.", (Throwable)e));
        }
        return null;
    }
}

