/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.scheduler.DisposableContainer;
import reactor.core.scheduler.ExecutorServiceScheduler;
import reactor.core.scheduler.ScheduledRunnable;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.OpenHashSet;

final class SingleScheduler
implements Scheduler,
Supplier<ScheduledExecutorService>,
TimedScheduler {
    static final AtomicLong COUNTER = new AtomicLong();
    static final AtomicLong TIMER_COUNTER = new AtomicLong();
    final ThreadFactory factory;
    volatile ScheduledExecutorService executor;
    static final AtomicReferenceFieldUpdater<SingleScheduler, ScheduledExecutorService> EXECUTORS = AtomicReferenceFieldUpdater.newUpdater(SingleScheduler.class, ScheduledExecutorService.class, "executor");
    static final ScheduledExecutorService TERMINATED = Executors.newSingleThreadScheduledExecutor();

    SingleScheduler(ThreadFactory factory) {
        this.factory = factory;
        this.init();
    }

    @Override
    public ScheduledExecutorService get() {
        ScheduledExecutorService e = Executors.newScheduledThreadPool(1, this.factory);
        ((ScheduledThreadPoolExecutor)e).setRemoveOnCancelPolicy(true);
        return e;
    }

    private void init() {
        EXECUTORS.lazySet(this, Schedulers.decorateScheduledExecutorService("single", this));
    }

    @Override
    public boolean isDisposed() {
        return this.executor == TERMINATED;
    }

    @Override
    public void start() {
        ScheduledExecutorService a;
        ExecutorService b = null;
        do {
            if ((a = this.executor) != TERMINATED) {
                if (b != null) {
                    b.shutdownNow();
                }
                return;
            }
            if (b != null) continue;
            b = Schedulers.decorateScheduledExecutorService("single", this);
        } while (!EXECUTORS.compareAndSet(this, a, (ScheduledExecutorService)b));
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        ScheduledExecutorService a = this.executor;
        if (a != TERMINATED && (a = EXECUTORS.getAndSet(this, TERMINATED)) != TERMINATED) {
            Schedulers.executorServiceShutdown(a, "single");
        }
    }

    @Override
    public Disposable schedule(Runnable task) {
        try {
            return new ExecutorServiceScheduler.DisposableFuture(this.executor.submit(task), false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        try {
            return new ExecutorServiceScheduler.DisposableFuture(this.executor.schedule(task, delay, unit), false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        try {
            return new ExecutorServiceScheduler.DisposableFuture(this.executor.scheduleAtFixedRate(task, initialDelay, period, unit), false);
        }
        catch (RejectedExecutionException ex) {
            return REJECTED;
        }
    }

    @Override
    public TimedScheduler.TimedWorker createWorker() {
        return new SingleWorker(this.executor);
    }

    static {
        TERMINATED.shutdownNow();
    }

    static final class SingleWorker
    implements Scheduler.Worker,
    DisposableContainer<ScheduledRunnable>,
    TimedScheduler.TimedWorker {
        final ScheduledExecutorService exec;
        OpenHashSet<ScheduledRunnable> tasks;
        volatile boolean shutdown;

        SingleWorker(ScheduledExecutorService exec) {
            this.exec = exec;
            this.tasks = new OpenHashSet();
        }

        @Override
        public Disposable schedule(Runnable task) {
            return this.schedule(task, 0L, TimeUnit.MILLISECONDS);
        }

        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            ScheduledRunnable sr = new ScheduledRunnable(task, this);
            this.add(sr);
            try {
                Future<?> f = delay <= 0L ? this.exec.submit(task) : this.exec.schedule(sr, delay, unit);
                sr.setFuture(f);
            }
            catch (RejectedExecutionException ex) {
                sr.dispose();
                return Scheduler.REJECTED;
            }
            return sr;
        }

        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            ScheduledRunnable sr = new ScheduledRunnable(task, this);
            this.add(sr);
            try {
                ScheduledFuture<?> f = this.exec.scheduleAtFixedRate(sr, initialDelay, period, unit);
                sr.setFuture(f);
            }
            catch (RejectedExecutionException ex) {
                sr.dispose();
                return Scheduler.REJECTED;
            }
            return sr;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            OpenHashSet<ScheduledRunnable> set;
            if (this.shutdown) {
                return;
            }
            SingleWorker singleWorker = this;
            synchronized (singleWorker) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null && !set.isEmpty()) {
                Object[] a;
                for (Object o : a = set.keys()) {
                    if (o == null) continue;
                    ((ScheduledRunnable)o).dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(ScheduledRunnable disposable) {
            Objects.requireNonNull(disposable, "disposable is null");
            if (!this.shutdown) {
                SingleWorker singleWorker = this;
                synchronized (singleWorker) {
                    if (!this.shutdown) {
                        this.tasks.add(disposable);
                        return true;
                    }
                }
            }
            disposable.dispose();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(ScheduledRunnable task) {
            if (this.shutdown) {
                return false;
            }
            SingleWorker singleWorker = this;
            synchronized (singleWorker) {
                if (this.shutdown) {
                    return false;
                }
                this.tasks.remove(task);
                return true;
            }
        }
    }
}

