/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Subscriber;
import reactor.core.Scannable;
import reactor.core.publisher.FluxHide;
import reactor.core.publisher.ParallelFlux;

final class ParallelFluxHide<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;

    ParallelFluxHide(ParallelFlux<T> source) {
        this.source = source;
    }

    @Override
    public long getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxHide.HideSubscriber<T>(subscribers[i]);
        }
        this.source.subscribe(parents);
    }
}

