/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoReduce<T>
extends MonoSource<T, T>
implements Fuseable {
    final BiFunction<T, T, T> aggregator;

    MonoReduce(Flux<? extends T> source, BiFunction<T, T, T> aggregator) {
        super(source);
        this.aggregator = Objects.requireNonNull(aggregator, "aggregator");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new ReduceSubscriber<T>(s, this.aggregator));
    }

    static final class ReduceSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final BiFunction<T, T, T> aggregator;
        Subscription s;
        T result;
        boolean done;

        ReduceSubscriber(Subscriber<? super T> actual, BiFunction<T, T, T> aggregator) {
            super(actual);
            this.aggregator = aggregator;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return super.scan(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            T r = this.result;
            if (r == null) {
                this.result = t;
            } else {
                try {
                    r = Objects.requireNonNull(this.aggregator.apply(r, t), "The aggregator returned a null value");
                }
                catch (Throwable ex) {
                    this.result = null;
                    this.done = true;
                    this.actual.onError(Operators.onOperatorError(this.s, ex, t));
                    return;
                }
                this.result = r;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.result = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T r = this.result;
            if (r != null) {
                this.complete(r);
            } else {
                this.actual.onComplete();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

