/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxFilterFuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;

final class MonoFilterFuseable<T>
extends MonoSource<T, T>
implements Fuseable {
    final Predicate<? super T> predicate;

    MonoFilterFuseable(Mono<? extends T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new FluxFilterFuseable.FilterFuseableConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)s, this.predicate));
            return;
        }
        this.source.subscribe(new FluxFilterFuseable.FilterFuseableSubscriber<T>(s, this.predicate));
    }
}

