/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class MonoDelayElement<T>
extends MonoSource<T, T> {
    final Scheduler timedScheduler;
    final long delay;
    final TimeUnit unit;

    MonoDelayElement(Mono<? extends T> source, long delay, TimeUnit unit, Scheduler timedScheduler) {
        super(source);
        this.delay = delay;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new DelayElementSubscriber<T>(s, this.timedScheduler, this.delay, this.unit));
    }

    static final class DelayElementSubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        final long delay;
        final Scheduler scheduler;
        final TimeUnit unit;
        Subscription s;
        volatile Cancellation task;
        volatile boolean done;

        DelayElementSubscriber(Subscriber<? super T> actual, Scheduler scheduler, long delay, TimeUnit unit) {
            super(actual);
            this.scheduler = scheduler;
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return super.scan(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            if (this.task != null) {
                this.task.dispose();
            }
            if (this.s != Operators.cancelledSubscription()) {
                this.s.cancel();
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(1L);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.done = true;
            Cancellation task = this.scheduler.schedule(() -> this.complete(t), this.delay, this.unit);
            if (task == Scheduler.REJECTED) {
                throw Operators.onRejectedExecution(this, null, t);
            }
            this.task = task;
            Subscription actualS = this.s;
            this.s = Operators.cancelledSubscription();
            actualS.cancel();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }
    }
}

