/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscriber;
import reactor.core.Cancellation;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxCreate;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;

final class MonoCreate<T>
extends Mono<T> {
    final Consumer<MonoSink<T>> callback;

    MonoCreate(Consumer<MonoSink<T>> callback) {
        this.callback = callback;
    }

    public void subscribe(Subscriber<? super T> s) {
        DefaultMonoSink<T> emitter = new DefaultMonoSink<T>(s);
        s.onSubscribe(emitter);
        try {
            this.callback.accept(emitter);
        }
        catch (Throwable ex) {
            emitter.error(Operators.onOperatorError(ex));
        }
    }

    static final class DefaultMonoSink<T>
    implements MonoSink<T>,
    InnerProducer<T> {
        final Subscriber<? super T> actual;
        volatile Disposable disposable;
        static final AtomicReferenceFieldUpdater<DefaultMonoSink, Disposable> DISPOSABLE = AtomicReferenceFieldUpdater.newUpdater(DefaultMonoSink.class, Disposable.class, "disposable");
        volatile int state;
        static final AtomicIntegerFieldUpdater<DefaultMonoSink> STATE = AtomicIntegerFieldUpdater.newUpdater(DefaultMonoSink.class, "state");
        volatile LongConsumer requestConsumer;
        static final AtomicReferenceFieldUpdater<DefaultMonoSink, LongConsumer> REQUEST_CONSUMER = AtomicReferenceFieldUpdater.newUpdater(DefaultMonoSink.class, LongConsumer.class, "requestConsumer");
        T value;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        DefaultMonoSink(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.state == 3 || this.state == 1;
                }
                case CANCELLED: {
                    return this.disposable == Flux.CANCELLED;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public void success() {
            if (STATE.getAndSet(this, 3) != 3) {
                try {
                    this.actual.onComplete();
                }
                finally {
                    this.disposeResource(false);
                }
            }
        }

        @Override
        public void success(T value) {
            int s;
            if (value == null) {
                this.success();
                return;
            }
            do {
                if ((s = this.state) == 3 || s == 1) {
                    return;
                }
                if (s == 2) {
                    if (STATE.compareAndSet(this, s, 3)) {
                        try {
                            this.actual.onNext(value);
                            this.actual.onComplete();
                        }
                        finally {
                            this.disposeResource(false);
                        }
                    }
                    return;
                }
                this.value = value;
            } while (!STATE.compareAndSet(this, s, 1));
        }

        @Override
        public void error(Throwable e) {
            if (STATE.getAndSet(this, 3) != 3) {
                try {
                    this.actual.onError(e);
                }
                finally {
                    this.disposeResource(false);
                }
            } else {
                Operators.onErrorDropped(e);
            }
        }

        @Override
        public MonoSink<T> onRequest(LongConsumer consumer) {
            if (!REQUEST_CONSUMER.compareAndSet(this, null, consumer)) {
                throw new IllegalStateException("A consumer has already been assigned to consume requests");
            }
            return this;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public MonoSink<T> onCancel(Disposable d) {
            Disposable c;
            FluxCreate.SinkDisposable sd;
            if (d != null && !DISPOSABLE.compareAndSet(this, null, sd = new FluxCreate.SinkDisposable(null, d)) && (c = this.disposable) instanceof FluxCreate.SinkDisposable) {
                FluxCreate.SinkDisposable current = (FluxCreate.SinkDisposable)c;
                if (current.onCancel == null) {
                    current.onCancel = d;
                } else {
                    d.dispose();
                }
            }
            return this;
        }

        @Override
        public MonoSink<T> onDispose(Disposable d) {
            Disposable c;
            FluxCreate.SinkDisposable sd;
            if (d != null && !DISPOSABLE.compareAndSet(this, null, sd = new FluxCreate.SinkDisposable(d, null)) && (c = this.disposable) instanceof FluxCreate.SinkDisposable) {
                FluxCreate.SinkDisposable current = (FluxCreate.SinkDisposable)c;
                if (current.disposable == null) {
                    current.disposable = d;
                } else {
                    d.dispose();
                }
            }
            return this;
        }

        @Override
        @Deprecated
        public void setCancellation(final Cancellation c) {
            this.onCancel(new Disposable(){

                @Override
                public void dispose() {
                    c.dispose();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            if (Operators.validate(n)) {
                int s;
                LongConsumer consumer = this.requestConsumer;
                if (consumer != null) {
                    consumer.accept(n);
                }
                do {
                    if ((s = this.state) == 2 || s == 3) {
                        return;
                    }
                    if (s != 1) continue;
                    if (STATE.compareAndSet(this, s, 3)) {
                        try {
                            this.actual.onNext(this.value);
                            this.actual.onComplete();
                        }
                        finally {
                            this.disposeResource(false);
                        }
                    }
                    return;
                } while (!STATE.compareAndSet(this, s, 2));
                return;
            }
        }

        public void cancel() {
            if (STATE.getAndSet(this, 3) != 3) {
                this.value = null;
                this.disposeResource(true);
            }
        }

        void disposeResource(boolean isCancel) {
            Disposable d = this.disposable;
            if (d != Flux.CANCELLED && (d = DISPOSABLE.getAndSet(this, Flux.CANCELLED)) != null && d != Flux.CANCELLED) {
                if (isCancel && d instanceof FluxCreate.SinkDisposable) {
                    ((FluxCreate.SinkDisposable)d).cancel();
                }
                d.dispose();
            }
        }
    }
}

