/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;

public class FluxSource<I, O>
extends Flux<O>
implements Scannable,
Receiver {
    protected final Publisher<? extends I> source;

    public static <I> Flux<I> wrap(Publisher<? extends I> source) {
        if (source instanceof Fuseable) {
            return new FuseableFluxSource<I>(source);
        }
        return new FluxSource(source);
    }

    protected FluxSource(Publisher<? extends I> source) {
        this.source = Objects.requireNonNull(source);
    }

    public void subscribe(Subscriber<? super O> s) {
        this.source.subscribe(s);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append('{').append(" \"operator\" : ").append('\"').append(this.getClass().getSimpleName().replaceAll("Flux", "")).append('\"').append(' ').append('}').toString();
    }

    public final Publisher<? extends I> upstream() {
        return this.source;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PREFETCH: {
                return this.getPrefetch();
            }
            case PARENT: {
                return this.source;
            }
        }
        return null;
    }

    static final class FuseableFluxSource<I>
    extends FluxSource<I, I>
    implements Fuseable {
        FuseableFluxSource(Publisher<? extends I> source) {
            super(source);
        }
    }
}

