/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxSampleFirst<T, U>
extends FluxSource<T, T> {
    final Function<? super T, ? extends Publisher<U>> throttler;

    FluxSampleFirst(Flux<? extends T> source, Function<? super T, ? extends Publisher<U>> throttler) {
        super(source);
        this.throttler = Objects.requireNonNull(throttler, "throttler");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        SampleFirstMain main = new SampleFirstMain(s, this.throttler);
        s.onSubscribe(main);
        this.source.subscribe(main);
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    static final class SampleFirstOther<U>
    extends Operators.DeferredSubscription
    implements InnerConsumer<U> {
        final SampleFirstMain<?, U> main;

        SampleFirstOther(SampleFirstMain<?, U> main) {
            this.main = main;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case ACTUAL: {
                    return this.main;
                }
            }
            return super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            this.cancel();
            this.main.otherNext();
        }

        public void onError(Throwable t) {
            this.main.otherError(t);
        }

        public void onComplete() {
            this.main.otherNext();
        }
    }

    static final class SampleFirstMain<T, U>
    implements InnerOperator<T, T> {
        final Function<? super T, ? extends Publisher<U>> throttler;
        final Subscriber<? super T> actual;
        volatile boolean gate;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SampleFirstMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SampleFirstMain.class, Subscription.class, "s");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<SampleFirstMain, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(SampleFirstMain.class, Subscription.class, "other");
        volatile long requested;
        static final AtomicLongFieldUpdater<SampleFirstMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(SampleFirstMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SampleFirstMain> WIP = AtomicIntegerFieldUpdater.newUpdater(SampleFirstMain.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SampleFirstMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SampleFirstMain.class, Throwable.class, "error");

        @Override
        public final Subscriber<? super T> actual() {
            return this.actual;
        }

        SampleFirstMain(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<U>> throttler) {
            this.actual = actual;
            this.throttler = throttler;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(Scannable.from(this.other));
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.s;
                }
                case ERROR: {
                    return this.error;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
            Operators.terminate(OTHER, this);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.gate) {
                Publisher<U> p;
                this.gate = true;
                if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                    this.actual.onNext(t);
                    if (WIP.decrementAndGet(this) != 0) {
                        this.handleTermination();
                        return;
                    }
                } else {
                    return;
                }
                try {
                    p = Objects.requireNonNull(this.throttler.apply(t), "The throttler returned a null publisher");
                }
                catch (Throwable e) {
                    Operators.terminate(S, this);
                    this.error(Operators.onOperatorError(null, e, t));
                    return;
                }
                SampleFirstOther other = new SampleFirstOther(this);
                if (Operators.replace(OTHER, this, other)) {
                    p.subscribe(other);
                }
            }
        }

        void handleTermination() {
            Throwable e = Exceptions.terminate(ERROR, this);
            if (e != null && e != Exceptions.TERMINATED) {
                this.actual.onError(e);
            } else {
                this.actual.onComplete();
            }
        }

        void error(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                if (WIP.getAndIncrement(this) == 0) {
                    this.handleTermination();
                }
            } else {
                Operators.onErrorDropped(e);
            }
        }

        public void onError(Throwable t) {
            Operators.terminate(OTHER, this);
            this.error(t);
        }

        public void onComplete() {
            Operators.terminate(OTHER, this);
            if (WIP.getAndIncrement(this) == 0) {
                this.handleTermination();
            }
        }

        void otherNext() {
            this.gate = false;
        }

        void otherError(Throwable e) {
            Operators.terminate(S, this);
            this.error(e);
        }
    }
}

