/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxInterval
extends Flux<Long> {
    final Scheduler timedScheduler;
    final long initialDelay;
    final long period;
    final TimeUnit unit;

    FluxInterval(long initialDelay, long period, TimeUnit unit, Scheduler timedScheduler) {
        if (period < 0L) {
            throw new IllegalArgumentException("period >= 0 required but it was " + period);
        }
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    public void subscribe(Subscriber<? super Long> s) {
        Scheduler.Worker w = this.timedScheduler.createWorker();
        IntervalRunnable r = new IntervalRunnable(s, w);
        s.onSubscribe((Subscription)r);
        w.schedulePeriodically(r, this.initialDelay, this.period, this.unit);
    }

    static final class IntervalRunnable
    implements Runnable,
    Subscription,
    InnerProducer<Long> {
        final Subscriber<? super Long> actual;
        final Scheduler.Worker worker;
        volatile long requested;
        static final AtomicLongFieldUpdater<IntervalRunnable> REQUESTED = AtomicLongFieldUpdater.newUpdater(IntervalRunnable.class, "requested");
        long count;
        volatile boolean cancelled;

        IntervalRunnable(Subscriber<? super Long> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.worker = worker;
        }

        @Override
        public Subscriber<? super Long> actual() {
            return this.actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.cancelled;
                }
            }
            return InnerProducer.super.scan(key);
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                if (this.requested != 0L) {
                    this.actual.onNext((Object)this.count++);
                    if (this.requested != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                } else {
                    this.cancel();
                    this.actual.onError((Throwable)Exceptions.failWithOverflow("Could not emit value " + this.count + " due to lack of requests"));
                }
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.worker.dispose();
            }
        }
    }
}

