/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected.objectstore;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sonarsource.sonarlint.core.client.api.connected.objectstore.PathMapper;

public class HashingPathMapper
implements PathMapper<String> {
    private static final String HEX_LETTERS = "0123456789abcdef";
    private static final String HASHING_ALGORITHM = "SHA1";
    private static final int HASH_LENGTH = 40;
    private final Path base;
    private final int levels;

    public HashingPathMapper(Path base, int levels) {
        if (levels < 1) {
            throw new IllegalArgumentException("levels must be > 0");
        }
        if (levels > 40) {
            throw new IllegalArgumentException("levels must be less than the length of the generated hash: 40");
        }
        this.base = base;
        this.levels = levels;
    }

    @Override
    public Path apply(String key) {
        String hashedHexString = HashingPathMapper.toHexString(HashingPathMapper.toHash(key));
        Path path = this.base;
        for (int i = 0; i < this.levels; ++i) {
            path = path.resolve(hashedHexString.substring(i, i + 1));
        }
        return path.resolve(hashedHexString);
    }

    private static byte[] toHash(String key) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASHING_ALGORITHM);
            digest.update(key.getBytes(StandardCharsets.UTF_8));
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not get hashing algoritm: SHA1", e);
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder hex = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hex.append(HEX_LETTERS.charAt((b & 0xF0) >> 4)).append(HEX_LETTERS.charAt(b & 0xF));
        }
        return hex.toString();
    }
}

