/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.ProgressMonitor;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.LoadedAnalyzer;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleStorageStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ServerIssue;
import org.sonarsource.sonarlint.core.client.api.connected.StateListener;
import org.sonarsource.sonarlint.core.client.api.connected.StorageUpdateCheckResult;
import org.sonarsource.sonarlint.core.client.api.connected.UpdateResult;

public interface ConnectedSonarLintEngine {
    public State getState();

    public void stop(boolean var1);

    public void addStateListener(StateListener var1);

    public void removeStateListener(StateListener var1);

    public RuleDetails getRuleDetails(String var1);

    public AnalysisResults analyze(ConnectedAnalysisConfiguration var1, IssueListener var2, @Nullable LogOutput var3, @Nullable ProgressMonitor var4);

    public List<ServerIssue> getServerIssues(String var1, String var2);

    @CheckForNull
    public GlobalStorageStatus getGlobalStorageStatus();

    @CheckForNull
    public ModuleStorageStatus getModuleStorageStatus(String var1);

    public Map<String, RemoteModule> allModulesByKey();

    public Map<String, RemoteModule> downloadAllModules(ServerConfiguration var1, @Nullable ProgressMonitor var2);

    public UpdateResult update(ServerConfiguration var1, @Nullable ProgressMonitor var2);

    public void updateModule(ServerConfiguration var1, String var2, @Nullable ProgressMonitor var3);

    public StorageUpdateCheckResult checkIfGlobalStorageNeedUpdate(ServerConfiguration var1, @Nullable ProgressMonitor var2);

    public StorageUpdateCheckResult checkIfModuleStorageNeedUpdate(ServerConfiguration var1, String var2, @Nullable ProgressMonitor var3);

    public List<ServerIssue> downloadServerIssues(ServerConfiguration var1, String var2, String var3);

    public void downloadServerIssues(ServerConfiguration var1, String var2);

    public Collection<LoadedAnalyzer> getLoadedAnalyzers();

    public static enum State {
        UNKNOW,
        UPDATING,
        NEVER_UPDATED,
        NEED_UPDATE,
        UPDATED;

    }
}

