/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;
import org.springsource.ide.eclipse.commons.livexp.util.Filters;
import org.springsource.ide.eclipse.commons.livexp.util.Log;

public class TreeAwareViewerFilter
extends ViewerFilter {
    private static final boolean DEBUG = false;
    private Filter<String> baseFilter;
    private LabelProvider labels;
    private Cache<Object, Boolean> baseAcceptsChild = CacheBuilder.newBuilder().build();
    private ITreeContentProvider treeContent;
    private TreeViewer viewer;
    UpdateExpansionStates updateExpansionStates = new UpdateExpansionStates();

    public TreeAwareViewerFilter(TreeViewer viewer, Filter<String> baseFilter, LabelProvider labels, ITreeContentProvider treeContent) {
        this.viewer = viewer;
        this.labels = labels;
        this.treeContent = treeContent;
        this.setFilter(baseFilter);
    }

    private synchronized boolean accept(Object e) {
        boolean accepts;
        if (this.baseFilter.isTrivial()) {
            return true;
        }
        boolean baseAccepts = this.baseAccepts(e);
        boolean bl = accepts = baseAccepts || this.baseAcceptsParent(e) || this.baseAcceptsChild(e);
        if (accepts) {
            this.updateExpansionStates.setExpanded(e, baseAccepts || this.baseAcceptsChild(e));
        }
        return accepts;
    }

    private boolean baseAcceptsParent(Object e) {
        Object parent = this.treeContent.getParent(e);
        if (parent != null) {
            return this.baseAccepts(parent) || this.baseAcceptsParent(parent);
        }
        return false;
    }

    private boolean baseAcceptsChild(Object e) {
        try {
            return (Boolean)this.baseAcceptsChild.get(e, () -> {
                Object[] children = this.treeContent.getChildren(e);
                if (children != null) {
                    Object c;
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        c = objectArray[n2];
                        if (this.baseAccepts(c)) {
                            return true;
                        }
                        ++n2;
                    }
                    objectArray = children;
                    n = children.length;
                    n2 = 0;
                    while (n2 < n) {
                        c = objectArray[n2];
                        if (this.baseAcceptsChild(c)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            });
        }
        catch (Exception er) {
            Log.log(er);
            return false;
        }
    }

    private boolean baseAccepts(Object e) {
        String label = this.labels.getText(e);
        if (label == null) {
            label = "";
        }
        return this.baseFilter.accept(label);
    }

    public synchronized void setFilter(Filter<String> baseFilter) {
        this.baseAcceptsChild.invalidateAll();
        this.baseFilter = baseFilter == null ? Filters.acceptAll() : baseFilter;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.accept(element);
    }

    private static void debug(String msg) {
    }

    class UpdateExpansionStates
    extends UIJob {
        Set<Object> toExpand;
        Set<Object> toCollapse;

        public UpdateExpansionStates() {
            super("Update Tree Viewer Expansions After Search");
            this.toExpand = new HashSet<Object>();
            this.toCollapse = new HashSet<Object>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.toExpand.isEmpty() && this.toCollapse.isEmpty()) {
                return Status.OK_STATUS;
            }
            HashSet<Object> expandedElements = new HashSet<Object>((Collection<Object>)ImmutableList.copyOf((Object[])TreeAwareViewerFilter.this.viewer.getExpandedElements()));
            UpdateExpansionStates updateExpansionStates = this;
            synchronized (updateExpansionStates) {
                expandedElements.addAll(this.toExpand);
                expandedElements.removeAll(this.toCollapse);
                this.toExpand.clear();
                this.toCollapse.clear();
            }
            TreeAwareViewerFilter.this.viewer.setExpandedElements(expandedElements.toArray());
            return Status.OK_STATUS;
        }

        public synchronized void collapseElement(Object e) {
            this.toExpand.remove(e);
            this.toCollapse.add(e);
        }

        public synchronized void expandElement(Object e) {
            while (e != null) {
                this.toExpand.add(e);
                this.toCollapse.remove(e);
                e = TreeAwareViewerFilter.this.treeContent.getParent(e);
            }
            this.schedule();
        }

        public void setExpanded(Object e, boolean expand) {
            if (expand) {
                this.expandElement(e);
            } else {
                this.collapseElement(e);
            }
        }
    }
}

