/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui.util;

import java.time.Duration;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;
import org.springsource.ide.eclipse.commons.livexp.ui.Stylers;
import org.springsource.ide.eclipse.commons.livexp.ui.util.TreeAwareViewerFilter;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;
import org.springsource.ide.eclipse.commons.livexp.util.Filters;

public class SwtConnect {
    public static void connect(Text text, LiveVariable<String> model) {
        if (!text.isDisposed()) {
            text.addDisposeListener(de -> model.dispose());
            ModifyListener widgetListener = me -> {
                if (!text.isDisposed()) {
                    model.setValue(text.getText());
                }
            };
            text.addModifyListener(widgetListener);
            Disposable disconnect = model.onChange(UIValueListener.from((e, v) -> {
                String oldText = text.getText();
                String newText = (String)model.getValue();
                if (newText == null) {
                    newText = "";
                }
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
            }));
            text.addDisposeListener(de -> disconnect.dispose());
            model.onDispose(de -> text.removeModifyListener(widgetListener));
        }
    }

    public static void connectTextBasedFilter(TreeViewer viewer, LiveExpression<Filter<String>> searchBoxModel, LabelProvider labels, ITreeContentProvider treeContent) {
        TreeAwareViewerFilter viewerFilter = new TreeAwareViewerFilter(viewer, Filters.acceptAll(), labels, treeContent);
        Disposable disposable = searchBoxModel.onChange(UIValueListener.from((e, filter) -> {
            viewerFilter.setFilter((Filter)searchBoxModel.getValue());
            viewer.refresh(true);
        }));
        viewer.setFilters(new ViewerFilter[]{viewerFilter});
        viewer.getControl().addDisposeListener(de -> disposable.dispose());
        Stylers stylers = new Stylers(viewer.getTree().getFont());
        viewer.getControl().addDisposeListener(de -> {
            disposable.dispose();
            stylers.dispose();
        });
        ILabelProvider baseLabels = (ILabelProvider)viewer.getLabelProvider();
        Assert.isNotNull((Object)baseLabels);
        viewer.setLabelProvider((IBaseLabelProvider)SwtConnect.boldMatchedElements(stylers, baseLabels, Filters.delegatingTo(searchBoxModel)));
    }

    public static StyledCellLabelProvider boldMatchedElements(final Stylers stylers, final ILabelProvider baseLabels, final Filter<String> filter) {
        return new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                cell.setImage(baseLabels.getImage(element));
                String label = baseLabels.getText(element);
                StyledString styledLabel = new StyledString(label);
                if (filter.accept(label)) {
                    StyledString.Styler bold = stylers.bold();
                    for (IRegion r : filter.getHighlights(label)) {
                        styledLabel.setStyle(r.getOffset(), r.getLength(), bold);
                    }
                }
                cell.setStyleRanges(styledLabel.getStyleRanges());
                cell.setText(styledLabel.getString());
                cell.getControl().redraw();
            }
        };
    }

    public static void connect(final Label widget, final LiveExpression<String> model) {
        UIValueListener<String> modelListener = new UIValueListener<String>(){

            @Override
            protected void uiGotValue(LiveExpression<String> exp, String value) {
                String newText = (String)model.getValue();
                if (newText == null) {
                    newText = "";
                }
                widget.setText(newText);
            }
        };
        model.addListener((ValueListener<String>)modelListener);
        widget.addDisposeListener(xx -> model.removeListener(modelListener));
    }

    public static void connect(Label widget, LiveExpression<String> model, Duration delay) {
        if (delay == null || delay.isZero() || delay.isNegative()) {
            SwtConnect.connect(widget, model);
        } else {
            LiveExpression<String> delayedModel = model.delay(delay);
            widget.addDisposeListener(de -> delayedModel.dispose());
            SwtConnect.connect(widget, delayedModel);
        }
    }
}

