/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

public abstract class Validator
extends LiveExpression<ValidationResult> {
    public static final LiveExpression<ValidationResult> OK = Validator.constant(ValidationResult.OK);

    public Validator() {
        super(ValidationResult.OK);
    }

    public static Validator notEmpty(final LiveExpression<String> target, final String errorMessage) {
        return new Validator(){
            {
                this.dependsOn(liveExpression);
            }

            @Override
            protected ValidationResult compute() {
                String v = (String)target.getValue();
                if (v == null || v.trim().isEmpty()) {
                    return ValidationResult.error(errorMessage);
                }
                return ValidationResult.OK;
            }
        };
    }

    public static <T> LiveExpression<ValidationResult> notNull(final LiveExpression<T> target, final String errorMessage) {
        Validator v = new Validator(){

            @Override
            protected ValidationResult compute() {
                if (target.getValue() == null) {
                    return ValidationResult.error(errorMessage);
                }
                return ValidationResult.OK;
            }
        };
        v.dependsOn(target);
        return v;
    }

    public static LiveExpression<ValidationResult> alwaysError(String msg) {
        return LiveExpression.constant(ValidationResult.error(msg));
    }
}

