/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.eclipse.core.runtime.IStatus;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class ValidationResult {
    public final String msg;
    public int status;
    public static final ValidationResult OK = new ValidationResult(0, null);

    private ValidationResult(int status, String msg) {
        this.msg = msg;
        this.status = status;
    }

    public boolean isOk() {
        return this.status == 0;
    }

    public static ValidationResult error(String msg) {
        return new ValidationResult(4, msg);
    }

    public static ValidationResult warning(String msg) {
        return new ValidationResult(2, msg);
    }

    public static ValidationResult info(String msg) {
        return new ValidationResult(1, msg);
    }

    public ValidationResult withMessage(String newMsg) {
        return new ValidationResult(this.status, newMsg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
        result = 31 * result + this.status;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (this.msg == null ? other.msg != null : !this.msg.equals(other.msg)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return "ValidationResult [msg=" + this.msg + ", status=" + ValidationResult.status(this.status) + "]";
    }

    private static String status(int s) {
        switch (s) {
            case 4: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
        }
        return "" + s;
    }

    public int getMessageProviderStatus() {
        switch (this.status) {
            case 0: {
                return 0;
            }
            case 8: {
                return 3;
            }
            case 4: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    public static ValidationResult from(IStatus status) {
        if (status.isOK()) {
            return OK;
        }
        Throwable e = status.getException();
        String msg = e != null ? ExceptionUtil.getMessage(e) : status.getMessage();
        if (msg == null) {
            msg = "Error";
        }
        return new ValidationResult(status.getSeverity(), msg);
    }
}

