/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public abstract class UIValueListener<T>
implements ValueListener<T> {
    private NotifyingJob job = null;

    @Override
    public final void gotValue(LiveExpression<T> exp, T value) {
        if (Display.getCurrent() == null) {
            NotifyingJob job = this.job;
            if (job == null || job.exp != exp) {
                this.job = job = new NotifyingJob(exp);
            }
            job.schedule();
        } else {
            this.uiGotValue(exp, value);
        }
    }

    protected abstract void uiGotValue(LiveExpression<T> var1, T var2);

    public static <T> UIValueListener<T> from(final ValueListener<T> l) {
        return new UIValueListener<T>(){

            @Override
            protected void uiGotValue(LiveExpression<T> exp, T value) {
                l.gotValue(exp, value);
            }
        };
    }

    private class NotifyingJob
    extends UIJob {
        LiveExpression<T> exp;

        public NotifyingJob(LiveExpression<T> exp) {
            super("Notifying Job");
            this.exp = exp;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            UIValueListener.this.uiGotValue(this.exp, this.exp.getValue());
            return Status.OK_STATUS;
        }
    }
}

