/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public class DelegatingLiveExp<T>
extends LiveExpression<T> {
    private LiveVariable<LiveExpression<T>> _delegate = new LiveVariable();
    private ValueListener<T> delegateListener = (exp, value) -> this.refresh();

    public DelegatingLiveExp() {
        this.onDispose(d -> this._delegate.dispose());
    }

    @Override
    protected T compute() {
        LiveExpression delegate = (LiveExpression)this._delegate.getValue();
        if (delegate == null) {
            return null;
        }
        return (T)delegate.getValue();
    }

    public synchronized void setDelegate(LiveExpression<T> newDelegate) {
        LiveExpression oldDelegate = (LiveExpression)this._delegate.getValue();
        this._delegate.setValue(newDelegate);
        if (oldDelegate == newDelegate) {
            return;
        }
        if (oldDelegate != null) {
            oldDelegate.removeListener(this.delegateListener);
        }
        if (newDelegate == null) {
            this.refresh();
        } else {
            newDelegate.addListener(this.delegateListener);
        }
    }

    public LiveExpression<LiveExpression<T>> getDelegate() {
        return this._delegate;
    }
}

