/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl17;

import java.util.ArrayList;
import java.util.List;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNReporter;
import org.apache.subversion.javahl.types.Depth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.javahl17.SVNClientImpl;

public abstract class JavaHLReporter
implements ISVNReporter {
    private final List<Entry> entries = new ArrayList<Entry>();

    protected ISVNReporterBaton getReporter() {
        return new ISVNReporterBaton(){

            @Override
            public void report(org.tmatesoft.svn.core.io.ISVNReporter reporter) throws SVNException {
                for (Entry entry : JavaHLReporter.this.entries) {
                    entry.applyTo(reporter);
                }
            }
        };
    }

    @Override
    public void setPath(String path, long revision, Depth depth, boolean startEmpty, String lockToken) throws ClientException {
        Entry entry = new Entry();
        entry.kind = Kind.SET_PATH;
        entry.path = path;
        entry.revision = revision;
        entry.depth = depth;
        entry.startEmpty = startEmpty;
        entry.lockToken = lockToken;
        this.entries.add(entry);
    }

    @Override
    public void deletePath(String path) throws ClientException {
        Entry entry = new Entry();
        entry.kind = Kind.DELETE_PATH;
        entry.path = path;
        this.entries.add(entry);
    }

    @Override
    public void linkPath(String url, String path, long revision, Depth depth, boolean startEmpty, String lockToken) throws ClientException {
        Entry entry = new Entry();
        entry.kind = Kind.LINK_PATH;
        entry.url = url;
        entry.path = path;
        entry.revision = revision;
        entry.depth = depth;
        entry.startEmpty = startEmpty;
        entry.lockToken = lockToken;
        this.entries.add(entry);
    }

    @Override
    public abstract long finishReport() throws ClientException;

    @Override
    public void abortReport() throws ClientException {
        this.entries.clear();
    }

    @Override
    public void dispose() {
        this.entries.clear();
    }

    private static class Entry {
        Kind kind;
        String path;
        String url;
        long revision;
        Depth depth;
        boolean startEmpty;
        String lockToken;

        private Entry() {
        }

        public void applyTo(org.tmatesoft.svn.core.io.ISVNReporter reporter) throws SVNException {
            switch (this.kind) {
                case SET_PATH: {
                    reporter.setPath(this.path, this.lockToken, this.revision, SVNClientImpl.getDepth(this.depth), this.startEmpty);
                    break;
                }
                case LINK_PATH: {
                    reporter.linkPath(SVNURL.parseURIEncoded(this.url), this.path, this.lockToken, this.revision, SVNClientImpl.getDepth(this.depth), this.startEmpty);
                    break;
                }
                case DELETE_PATH: {
                    reporter.deletePath(this.path);
                    break;
                }
                default: {
                    throw new IllegalStateException("Uknown kind " + (Object)((Object)this.kind));
                }
            }
        }
    }

    private static enum Kind {
        SET_PATH,
        DELETE_PATH,
        LINK_PATH;

    }
}

