/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator.helper;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.w3c.dom.Node;

public class BeanConstructorArgumentHelper
extends BeanConstructorArgument
implements IBeanConstructorArgument {
    private final IBean parentBean;
    private final IDOMNode argNode;
    private final String name;

    private static String getElementValue(IDOMNode n) {
        if (n instanceof IDOMAttr) {
            return n.getNodeValue();
        }
        Node value = n.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_VALUE);
        if (value != null) {
            return value.getNodeValue();
        }
        value = n.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_REF);
        if (value != null) {
            return value.getNodeValue();
        }
        return null;
    }

    public BeanConstructorArgumentHelper(int index, IDOMNode argNode, IFile file, IBean parentBean) {
        this(index, null, argNode, file, parentBean);
    }

    public BeanConstructorArgumentHelper(int index, String name, IDOMNode argNode, IFile file, IBean parentBean) {
        super(parentBean, index, new ConstructorArgumentValues.ValueHolder((Object)BeanConstructorArgumentHelper.getElementValue(argNode)));
        this.argNode = argNode;
        this.parentBean = parentBean;
        this.name = name;
    }

    public IModelElement[] getElementChildren() {
        return new IModelElement[0];
    }

    public IModelElement getElementParent() {
        return this.parentBean;
    }

    public IResourceModelElement getElementSourceElement() {
        return this.parentBean;
    }

    public int getElementType() {
        return 10;
    }

    public Object getValue() {
        return BeanConstructorArgumentHelper.getElementValue(this.argNode);
    }

    public String getName() {
        return this.name;
    }
}

