/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.BeanDeprecationRule;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.BeanInitDestroyMethodRule;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidator;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeanHelper;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeansValidationContextHelper;

public class InitDestroyMethodValidator
extends BeanValidator {
    @Override
    public boolean validateAttributeWithConfig(IBeansConfig config, IResourceModelElement contextElement, IFile file, AttrImpl attribute, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator validator, String text) {
        ITextRegion valueRegion = attribute.getValueRegion();
        IProject project = file.getProject();
        ValidationRuleDefinition initRuleDefinition = this.getValidationRule(project, BeanInitDestroyMethodRule.class);
        BeanInitDestroyMethodRule initDestroyMethodRule = (BeanInitDestroyMethodRule)(initRuleDefinition != null ? initRuleDefinition.getRule() : null);
        BeanHelper parentBean = new BeanHelper(parent, file, project);
        BeansValidationContextHelper context = new BeansValidationContextHelper(attribute, parent, contextElement, project, reporter, validator, QuickfixProcessorFactory.INIT_DESTROY_METHOD, false, reportError, config);
        AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)parentBean.getBeanDefinition();
        if (attribute.getNodeName().equals(BeansSchemaConstants.ATTR_INIT_METHOD)) {
            beanDefinition.setInitMethodName(attribute.getNodeValue());
        } else if (attribute.getNodeName().equals(BeansSchemaConstants.ATTR_DESTROY_METHOD)) {
            beanDefinition.setDestroyMethodName(attribute.getNodeValue());
        }
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition((IBean)parentBean, (IModelElement)context.getContextElement());
        String mergedClassName = mergedBd.getBeanClassName();
        if (valueRegion != null && mergedClassName != null) {
            validator.createAndAddEmptyMessage(valueRegion, parent, "", reporter, QuickfixProcessorFactory.RENAME_METHOD, null, new ValidationProblemAttribute("CLASS", (Object)mergedClassName), new ValidationProblemAttribute("METHOD", (Object)attribute.getNodeValue()));
        }
        if (initDestroyMethodRule != null) {
            context.setCurrentRuleDefinition(initRuleDefinition);
            initDestroyMethodRule.validate((IBean)parentBean, (IBeansValidationContext)context, null);
        }
        if (context.getErrorFound()) {
            return true;
        }
        ValidationRuleDefinition depracationRuleDefinition = this.getValidationRule(project, BeanDeprecationRule.class);
        BeanDeprecationRule deprecationRule = (BeanDeprecationRule)(depracationRuleDefinition != null ? depracationRuleDefinition.getRule() : null);
        context = new BeansValidationContextHelper(attribute, parent, (IResourceModelElement)config, project, reporter, validator, QuickfixProcessorFactory.DEPRECATED, false, reportError, config);
        if (deprecationRule != null) {
            context.setCurrentRuleDefinition(depracationRuleDefinition);
            deprecationRule.validate((IBeansModelElement)parentBean, (IBeansValidationContext)context, null);
        }
        return context.getErrorFound();
    }
}

