/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.BeanFactoryRule;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidator;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeanHelper;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeansValidationContextHelper;

public class FactoryMethodValidator
extends BeanValidator {
    @Override
    public boolean validateAttributeWithConfig(IBeansConfig config, IResourceModelElement contextElement, IFile file, AttrImpl attribute, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator validator, String text) {
        IProject project = file.getProject();
        ValidationRuleDefinition ruleDefinition = this.getValidationRule(project, BeanFactoryRule.class);
        BeanFactoryRule rule = (BeanFactoryRule)(ruleDefinition != null ? ruleDefinition.getRule() : null);
        BeanHelper parentBean = new BeanHelper(parent, file, project);
        parentBean.getBeanDefinition().setFactoryMethodName(text);
        AttrImpl factoryBeanAttr = (AttrImpl)parent.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_FACTORY_BEAN);
        if (factoryBeanAttr != null) {
            parentBean.getBeanDefinition().setFactoryBeanName(factoryBeanAttr.getNodeValue());
        }
        BeansValidationContextHelper context = new BeansValidationContextHelper(attribute, parent, contextElement, project, reporter, validator, QuickfixProcessorFactory.FACTORY_METHOD, false, reportError, config);
        ITextRegion valueRegion = attribute.getValueRegion();
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition((IBean)parentBean, (IModelElement)context.getContextElement());
        String mergedClassName = mergedBd.getBeanClassName();
        if (valueRegion != null && mergedClassName != null) {
            validator.createAndAddEmptyMessage(valueRegion, parent, "", reporter, QuickfixProcessorFactory.RENAME_METHOD, null, new ValidationProblemAttribute("CLASS", (Object)mergedClassName));
        }
        if (rule != null) {
            context.setCurrentRuleDefinition(ruleDefinition);
            rule.validate((IBean)parentBean, (IBeansValidationContext)context, null);
            if (context.getErrorFound()) {
                return true;
            }
        }
        return false;
    }
}

