/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.model.update.BeansModelUpdater;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;

public class AddConfigSetQuickFixProposal
extends BeanAttributeQuickFixProposal
implements ICompletionProposal {
    private final String configName;
    private final String referencedConfigName;
    private final BeansProject project;
    private String configSetName;

    public AddConfigSetQuickFixProposal(int offset, int length, boolean missingEndQuote, IBean importBean, IFile file) {
        super(offset, length, missingEndQuote);
        this.configName = QuickfixUtils.getConfigName((IResource)file);
        this.referencedConfigName = QuickfixUtils.getConfigName(importBean.getElementResource());
        IBeansModel model = BeansCorePlugin.getModel();
        this.project = (BeansProject)model.getProject(file.getProject());
    }

    public AddConfigSetQuickFixProposal(int offset, int length, boolean missingEndQuote, IBean importBean, IFile file, String configSetName) {
        this(offset, length, missingEndQuote, importBean, file);
        this.configSetName = configSetName;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        WizardDialog dialog;
        ConfigSetNameWizard wizard = new ConfigSetNameWizard();
        if (this.configSetName == null && (dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard)).open() == 0) {
            this.configSetName = wizard.getConfigSetName();
        }
        if (this.configSetName != null) {
            HashSet<String> configNames = new HashSet<String>();
            configNames.add(this.configName);
            configNames.add(this.referencedConfigName);
            BeansConfigSet configSet = new BeansConfigSet((IBeansProject)this.project, this.configSetName, configNames, IBeansConfigSet.Type.MANUAL);
            this.project.addConfigSet((IBeansConfigSet)configSet);
            this.project.saveDescription();
            BeansModelUpdater.updateProject((IBeansProject)this.project);
        }
    }

    public String getDisplayString() {
        return "Create new config set with " + this.configName + " and " + this.referencedConfigName;
    }

    public Image getImage() {
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.configset_obj.gif");
    }

    private class ConfigSetNameWizard
    extends Wizard {
        private String configSetName;
        private ConfigSetNameWizardPage page;

        public ConfigSetNameWizard() {
            this.setWindowTitle("Bean Reference Quick Fix");
        }

        public void addPages() {
            this.page = new ConfigSetNameWizardPage();
            this.addPage((IWizardPage)this.page);
        }

        public String getConfigSetName() {
            return this.configSetName;
        }

        public boolean performFinish() {
            this.configSetName = this.page.getConfigSetName();
            return true;
        }
    }

    private class ConfigSetNameWizardPage
    extends WizardPage {
        private Text text;
        private String configSetName;
        private boolean canFinish;

        protected ConfigSetNameWizardPage() {
            super("configSetNameWizardPage");
        }

        public boolean canFlipToNextPage() {
            return this.canFinish;
        }

        public void createControl(Composite parent) {
            this.setTitle("Create New Config Set");
            this.setMessage("Enter the name for the new config set.");
            parent.setLayout((Layout)new GridLayout());
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout(2, false));
            control.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(control, 0);
            label.setText("Name: ");
            label.setLayoutData((Object)new GridData(4, 4, false, false));
            this.text = new Text(control, 2048);
            this.text.setEditable(true);
            this.text.setLayoutData((Object)new GridData(4, 4, true, false));
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ConfigSetNameWizardPage.this.configSetName = ConfigSetNameWizardPage.this.text.getText();
                    ConfigSetNameWizardPage.this.update();
                    ConfigSetNameWizardPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.setControl((Control)control);
        }

        public String getConfigSetName() {
            return this.configSetName;
        }

        private void update() {
            String name = this.text.getText();
            if (name != null && name.length() > 0) {
                if (!AddConfigSetQuickFixProposal.this.project.hasConfigSet(name)) {
                    this.canFinish = true;
                    this.setErrorMessage(null);
                } else {
                    this.canFinish = false;
                    this.setErrorMessage("A config set with name " + name + " already exists.");
                }
            } else {
                this.canFinish = false;
                this.setErrorMessage(null);
            }
        }
    }
}

