/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.FactoryMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.InitDestroyMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.BeanReferenceQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.ClassAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.ClassDeprecatedQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.ConstructorArgNameQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.ConstructorArgQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.MethodAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.MethodDeprecatedQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.MissingFactoryMethodAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.NameSpaceElementsQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.PropertyAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.RenameMethodQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.RenamePropertyQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.RequiredPropertyQuickAssistProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum QuickfixProcessorFactory {
    CLASS,
    PROPERTY,
    REF,
    FACTORY_METHOD,
    INIT_DESTROY_METHOD,
    CONSTRUCTOR_ARG,
    RENAME_PROPERTY,
    RENAME_METHOD,
    DEPRECATED,
    BEAN_DEFINITION,
    REQUIRED_PROPERTY,
    NAMESPACE,
    NAMESPACE_ELEMENTS,
    FACTORY_BEAN,
    ALIAS;


    public BeanQuickAssistProcessor create(int offset, int length, String text, boolean missingEndQuote, IDOMNode parentNode, BeansEditorValidator validator, String problemId, ValidationProblemAttribute ... problemAttributes) {
        boolean isStatic = true;
        IProject project = validator.getProject();
        IFile file = validator.getFile();
        HashSet<String> properties = new HashSet<String>();
        ArrayList<String> refClassNames = new ArrayList<String>();
        Map referenceableNodes = BeansEditorUtils.getReferenceableNodes((Document)parentNode.getOwnerDocument(), (IFile)file);
        NodeList childNodes = parentNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            String localName = child.getLocalName();
            if (localName != null) {
                if (localName.equals(BeansSchemaConstants.ELEM_PROPERTY)) {
                    properties.add(this.getPropertyName(child));
                } else if (localName.equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG)) {
                    String ref;
                    NamedNodeMap attributes = child.getAttributes();
                    Node refAttr = attributes.getNamedItem(BeansSchemaConstants.ATTR_REF);
                    String refClassName = "Object";
                    if (refAttr != null && (ref = refAttr.getNodeValue()) != null) {
                        Node refNode = (Node)referenceableNodes.get(ref);
                        refClassName = BeansEditorUtils.getClassNameForBean((Node)refNode);
                    }
                    refClassNames.add(refClassName);
                }
            }
            ++i;
        }
        String className = null;
        String beanName = null;
        IMethod method = null;
        int numConstructorArgs = -1;
        List missingProperties = null;
        ValidationProblemAttribute[] validationProblemAttributeArray = problemAttributes;
        int n = problemAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationProblemAttribute problemAttribute = validationProblemAttributeArray[n2];
            String attributeKey = problemAttribute.getKey();
            if ("CLASS".equals(attributeKey)) {
                className = (String)problemAttribute.getValue();
            } else if ("BEAN".equals(attributeKey)) {
                beanName = (String)problemAttribute.getValue();
            } else if ("MISSING_PROPERTIES".equals(attributeKey)) {
                missingProperties = (List)problemAttribute.getValue();
            } else if ("METHOD_OBJ".equals(attributeKey)) {
                method = (IMethod)problemAttribute.getValue();
            } else if ("NUM_CONSTRUCTOR_ARGS".equals(attributeKey)) {
                numConstructorArgs = (Integer)problemAttribute.getValue();
            }
            ++n2;
        }
        if (numConstructorArgs < 0) {
            numConstructorArgs = refClassNames.size();
        }
        switch (this) {
            case CLASS: {
                if ("CLASS_NOT_FOUND".equals(problemId)) {
                    return new ClassAttributeQuickAssistProcessor(offset, length, text, project, missingEndQuote, properties, numConstructorArgs);
                }
            }
            case PROPERTY: {
                if (className == null) break;
                if ("NO_GETTER".equals(problemId)) {
                    return new PropertyAttributeQuickAssistProcessor(offset, length, className, text, project, missingEndQuote, PropertyAttributeQuickAssistProcessor.Type.GETTER);
                }
                if (!"NO_SETTER".equals(problemId)) break;
                return new PropertyAttributeQuickAssistProcessor(offset, length, className, text, project, missingEndQuote, PropertyAttributeQuickAssistProcessor.Type.SETTER);
            }
            case REF: {
                if (!"UNDEFINED_PARENT_BEAN".equals(problemId) && !"UNDEFINED_DEPENDS_ON_BEAN".equals(problemId) && !"UNDEFINED_FACTORY_BEAN".equals(problemId) && !"UNDEFINED_REFERENCED_BEAN".equals(problemId)) break;
                return new BeanReferenceQuickAssistProcessor(offset, length, text, missingEndQuote, parentNode, BeansSchemaConstants.ATTR_REF, beanName, file);
            }
            case FACTORY_METHOD: {
                if (!"NO_FACTORY_METHOD".equals(problemId) && !"UNDEFINED_FACTORY_BEAN_METHOD".equals(problemId)) break;
                return new MethodAttributeQuickAssistProcessor(offset, length, className, text, missingEndQuote, parentNode, BeansSchemaConstants.ATTR_FACTORY_METHOD, project, isStatic, (IContentAssistCalculator)new FactoryMethodContentAssistCalculator(), file);
            }
            case FACTORY_BEAN: {
                if ("UNDEFINED_FACTORY_BEAN".equals(problemId)) {
                    return new BeanReferenceQuickAssistProcessor(offset, length, text, missingEndQuote, parentNode, BeansSchemaConstants.ATTR_FACTORY_BEAN, beanName, file);
                }
                if ("NO_FACTORY_METHOD".equals(problemId) || "UNDEFINED_FACTORY_BEAN_METHOD".equals(problemId)) {
                    return new MissingFactoryMethodAttributeQuickAssistProcessor(offset, length, text, missingEndQuote, parentNode);
                }
            }
            case INIT_DESTROY_METHOD: {
                if ("UNDEFINED_INIT_METHOD".equals(problemId)) {
                    return new MethodAttributeQuickAssistProcessor(offset, length, className, text, missingEndQuote, parentNode, BeansSchemaConstants.ATTR_INIT_METHOD, project, isStatic, (IContentAssistCalculator)new InitDestroyMethodContentAssistCalculator(), file);
                }
                if ("UNDEFINED_DESTROY_METHOD".equals(problemId)) {
                    return new MethodAttributeQuickAssistProcessor(offset, length, className, text, missingEndQuote, parentNode, BeansSchemaConstants.ATTR_DESTROY_METHOD, project, isStatic, (IContentAssistCalculator)new InitDestroyMethodContentAssistCalculator(), file);
                }
            }
            case CONSTRUCTOR_ARG: {
                if ("NO_CONSTRUCTOR".equals(problemId)) {
                    return new ConstructorArgQuickAssistProcessor(offset, length, text, project, missingEndQuote, refClassNames, parentNode);
                }
                if (!"MISSING_CONSTRUCTOR_ARG_NAME".equals(problemId)) break;
                return new ConstructorArgNameQuickAssistProcessor(offset, length, text, className, project, missingEndQuote, numConstructorArgs, parentNode);
            }
            case RENAME_PROPERTY: {
                return new RenamePropertyQuickAssistProcessor(offset, length, className, text, project, missingEndQuote, validator.getFile());
            }
            case RENAME_METHOD: {
                return new RenameMethodQuickAssistProcessor(offset, length, className, text, project, missingEndQuote, validator.getFile());
            }
            case NAMESPACE_ELEMENTS: {
                return new NameSpaceElementsQuickAssistProcessor(problemId, offset, length, text, missingEndQuote, project, parentNode, file, problemAttributes);
            }
            case REQUIRED_PROPERTY: {
                if (missingProperties == null) break;
                return new RequiredPropertyQuickAssistProcessor(offset, length, text, missingEndQuote, missingProperties, parentNode);
            }
            case DEPRECATED: {
                if ("CLASS_IS_DEPRECATED".equals(problemId) && className != null) {
                    return new ClassDeprecatedQuickAssistProcessor(offset, length, text, missingEndQuote, className, project);
                }
                if (!"METHOD_IS_DEPRECATED".equals(problemId) || method == null || className == null) break;
                return new MethodDeprecatedQuickAssistProcessor(offset, length, text, missingEndQuote, className, method.getElementName(), method);
            }
        }
        return null;
    }

    private String getPropertyName(Node child) {
        NamedNodeMap attributes = child.getAttributes();
        Node attribute = attributes.getNamedItem(BeansSchemaConstants.ATTR_NAME);
        return attribute.getNodeValue();
    }
}

