/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class RequestMappingParamTypeProposalComputer
extends JavaCompletionProposalComputer {
    private static Class<?>[] PARAM_TYPE_CLASSES = new Class[]{ServletRequest.class, HttpServletRequest.class, HttpSession.class, WebRequest.class, NativeWebRequest.class, Locale.class, InputStream.class, Reader.class, OutputStream.class, Writer.class, Map.class, Model.class, ModelMap.class, Errors.class, BindingResult.class, SessionStatus.class};

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ITextViewer viewer;
        ICompilationUnit cu;
        JavaContentAssistInvocationContext javaContext;
        if (context instanceof JavaContentAssistInvocationContext && SpringCoreUtils.isSpringProject((IResource)(javaContext = (JavaContentAssistInvocationContext)context).getProject().getProject()) && ProposalCalculatorUtil.hasAnnotationOnType(cu = javaContext.getCompilationUnit(), "Controller") && (viewer = javaContext.getViewer()) instanceof SourceViewer) {
            Block block;
            ASTNode parentNode;
            SourceViewer sourceViewer = (SourceViewer)viewer;
            int invocationOffset = context.getInvocationOffset();
            AssistContext assistContext = new AssistContext(cu, (ISourceViewer)sourceViewer, invocationOffset, 0, SharedASTProvider.WAIT_NO);
            ASTNode node = assistContext.getCoveringNode();
            if (node instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)node;
                if (ProposalCalculatorUtil.hasAnnotation("RequestMapping", (ASTNode)methodDecl)) {
                    try {
                        IDocument document = sourceViewer.getDocument();
                        int relativeOffset = invocationOffset - methodDecl.getStartPosition();
                        String methodText = document.get(methodDecl.getStartPosition(), methodDecl.getLength());
                        String methodName = methodDecl.getName().getFullyQualifiedName();
                        int getterLocation = methodText.indexOf(methodName) + methodName.length();
                        if (getterLocation < relativeOffset) {
                            return this.getProposals(methodDecl, "", invocationOffset, null, javaContext);
                        }
                    }
                    catch (BadLocationException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", e.getMessage(), (Throwable)e));
                    }
                }
            } else if (node instanceof SimpleName) {
                SingleVariableDeclaration varDecl;
                SimpleType sType;
                SimpleName name = (SimpleName)node;
                ASTNode parentNode2 = name.getParent();
                if (parentNode2 instanceof VariableDeclarationFragment) {
                    VariableDeclarationStatement varDeclStmt;
                    Type varDeclType;
                    if ((parentNode2 = parentNode2.getParent()) instanceof VariableDeclarationStatement && (varDeclType = (varDeclStmt = (VariableDeclarationStatement)parentNode2).getType()) instanceof SimpleType) {
                        SimpleType sType2 = (SimpleType)varDeclType;
                        if ((parentNode2 = parentNode2.getParent()) instanceof Block) {
                            Block block2 = (Block)parentNode2;
                            try {
                                if (viewer.getDocument().getChar(block2.getStartPosition()) != '{' && (parentNode2 = parentNode2.getParent()) instanceof MethodDeclaration) {
                                    MethodDeclaration methodDecl = (MethodDeclaration)parentNode2;
                                    return this.getProposals(methodDecl, sType2.getName().getFullyQualifiedName(), invocationOffset, (ASTNode)varDeclStmt, javaContext);
                                }
                            }
                            catch (BadLocationException e) {
                                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", e.getMessage(), (Throwable)e));
                            }
                        }
                    }
                } else if (parentNode2 instanceof SimpleType && (parentNode2 = (sType = (SimpleType)parentNode2).getParent()) instanceof SingleVariableDeclaration && (parentNode2 = (varDecl = (SingleVariableDeclaration)parentNode2).getParent()) instanceof MethodDeclaration) {
                    MethodDeclaration methodDecl = (MethodDeclaration)parentNode2;
                    return this.getProposals(methodDecl, sType.getName().getFullyQualifiedName(), invocationOffset, (ASTNode)sType, javaContext);
                }
            } else if (node instanceof Block && (parentNode = (block = (Block)node).getParent()) instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)parentNode;
                try {
                    String blockContent = viewer.getDocument().get(block.getStartPosition(), block.getLength());
                    if (blockContent.startsWith(",")) {
                        blockContent = blockContent.substring(1);
                        boolean isAnnotation = false;
                        while (blockContent.length() > 0) {
                            char currChar = blockContent.charAt(0);
                            if (Character.isWhitespace(currChar)) {
                                blockContent = blockContent.substring(1);
                                isAnnotation = false;
                                continue;
                            }
                            if (currChar == '@') {
                                blockContent = blockContent.substring(1);
                                isAnnotation = true;
                                continue;
                            }
                            if (!Character.isLetter(currChar) || !isAnnotation) break;
                            blockContent = blockContent.substring(1);
                        }
                        if (blockContent.length() > 0 && blockContent.charAt(0) == '@') {
                            blockContent = blockContent.substring(1);
                        }
                        StringBuilder filter = new StringBuilder();
                        while (blockContent.length() > 0) {
                            char currChar = blockContent.charAt(0);
                            if (!Character.isLetter(currChar)) break;
                            filter.append(currChar);
                            blockContent = blockContent.substring(1);
                        }
                        return this.getProposals(methodDecl, filter.toString(), invocationOffset, (ASTNode)block, javaContext);
                    }
                }
                catch (BadLocationException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", e.getMessage(), (Throwable)e));
                }
            }
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> getProposals(MethodDeclaration methodDecl, String filter, int offset, ASTNode toBeRemoved, JavaContentAssistInvocationContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Class<?>[] classArray = PARAM_TYPE_CLASSES;
        int n = PARAM_TYPE_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType = classArray[n2];
            if (paramType.getSimpleName().toLowerCase().startsWith(filter.toLowerCase())) {
                CompletionProposal proposal = CompletionProposal.create((int)9, (int)context.getInvocationOffset());
                proposal.setCompletion(paramType.getCanonicalName().toCharArray());
                proposal.setDeclarationSignature(paramType.getPackage().getName().toCharArray());
                proposal.setFlags(paramType.getModifiers());
                proposal.setRelevance(Integer.MAX_VALUE);
                proposal.setReplaceRange(context.getInvocationOffset() - filter.length(), context.getInvocationOffset());
                proposal.setSignature(Signature.createTypeSignature((String)paramType.getCanonicalName(), (boolean)true).toCharArray());
                LazyJavaTypeCompletionProposal typeProposal = new LazyJavaTypeCompletionProposal(proposal, context);
                typeProposal.setRelevance(Integer.MAX_VALUE);
                proposals.add((ICompletionProposal)typeProposal);
            }
            ++n2;
        }
        return proposals;
    }
}

