/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springframework.ide.eclipse.webflow.core.internal.model.ActionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.DecisionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EndState;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.ViewState;
import org.springframework.ide.eclipse.webflow.ui.graph.Activator;
import org.springframework.ide.eclipse.webflow.ui.graph.preferences.WebflowGraphPreferences;

public class WebflowGraphColorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor viewStateColorEditor;
    private ColorFieldEditor actionStateColorEditor;
    private ColorFieldEditor subflowStateColorEditor;
    private ColorFieldEditor decisionStateColorEditor;
    private ColorFieldEditor endStateColorEditor;

    protected Control createContents(Composite parent) {
        Composite entryTable = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        entryTable.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        entryTable.setLayout((Layout)layout);
        Label label = new Label(entryTable, 64);
        label.setText("Use this preference page to adjust the background colors of the state shapes within the Web Flow Editor.");
        label.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        label.setLayoutData((Object)gd);
        Composite colorComposite = new Composite(entryTable, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        colorComposite.setLayoutData((Object)new GridData(768));
        Group group = new Group(colorComposite, 0);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText("State Colors");
        Composite colorComposite2 = new Composite((Composite)group, 0);
        colorComposite2.setLayout((Layout)layout);
        colorComposite2.setLayoutData((Object)new GridData(768));
        this.viewStateColorEditor = new ColorFieldEditor(WebflowGraphPreferences.getPreferenceName(ViewState.class.getName()), "View State:", colorComposite2);
        this.viewStateColorEditor.setPage((DialogPage)this);
        this.viewStateColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.viewStateColorEditor.load();
        this.actionStateColorEditor = new ColorFieldEditor(WebflowGraphPreferences.getPreferenceName(ActionState.class.getName()), "Action State:", colorComposite2);
        this.actionStateColorEditor.setPage((DialogPage)this);
        this.actionStateColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.actionStateColorEditor.load();
        this.subflowStateColorEditor = new ColorFieldEditor(WebflowGraphPreferences.getPreferenceName(SubflowState.class.getName()), "Subflow State:", colorComposite2);
        this.subflowStateColorEditor.setPage((DialogPage)this);
        this.subflowStateColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.subflowStateColorEditor.load();
        this.decisionStateColorEditor = new ColorFieldEditor(WebflowGraphPreferences.getPreferenceName(DecisionState.class.getName()), "Decision State:", colorComposite2);
        this.decisionStateColorEditor.setPage((DialogPage)this);
        this.decisionStateColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.decisionStateColorEditor.load();
        this.endStateColorEditor = new ColorFieldEditor(WebflowGraphPreferences.getPreferenceName(EndState.class.getName()), "End State", colorComposite2);
        this.endStateColorEditor.setPage((DialogPage)this);
        this.endStateColorEditor.setPreferenceStore(this.getPreferenceStore());
        this.endStateColorEditor.load();
        return entryTable;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.viewStateColorEditor.loadDefault();
        this.actionStateColorEditor.loadDefault();
        this.subflowStateColorEditor.loadDefault();
        this.decisionStateColorEditor.loadDefault();
        this.endStateColorEditor.loadDefault();
    }

    public boolean performOk() {
        this.viewStateColorEditor.store();
        this.actionStateColorEditor.store();
        this.subflowStateColorEditor.store();
        this.decisionStateColorEditor.store();
        this.endStateColorEditor.store();
        WebflowGraphPreferences.clearColorCache();
        return super.performOk();
    }
}

