/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.BeanActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.EvaluateActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.SetActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;

public class ActionComposite {
    private TableViewer configsViewer;
    private Button editButton;
    private Button addActionButton;
    private Button addBeanActionButton;
    private Button addEvaluationButton;
    private Button addSetButton;
    private Button deleteButton;
    private Shell parentShell;
    private List<IActionElement> actions;
    private IWebflowModelElement parentElement;
    private IActionElement.ACTION_TYPE type;

    public ActionComposite(IDialogValidator validator, TabItem item, Shell parentShell, List<IActionElement> actions, IWebflowModelElement parentElement, IActionElement.ACTION_TYPE type) {
        this.actions = actions;
        if (type == IActionElement.ACTION_TYPE.ACTION) {
            item.setText("Actions");
            item.setToolTipText("Define element's actions");
        } else if (type == IActionElement.ACTION_TYPE.ENTRY_ACTION) {
            item.setText("Entry Actions");
            item.setToolTipText("Define element's entry actions");
        } else if (type == IActionElement.ACTION_TYPE.EXIT_ACTION) {
            item.setText("Exit Actions");
            item.setToolTipText("Define element's exit actions");
        } else if (type == IActionElement.ACTION_TYPE.RENDER_ACTION) {
            item.setText("Render Actions");
            item.setToolTipText("Define element's render actions");
        }
        item.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.actions_obj.gif"));
        this.parentShell = parentShell;
        this.parentElement = parentElement;
        this.type = type;
    }

    protected Control createDialogArea(Composite parent) {
        Group groupActionType = new Group(parent, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Actions ");
        groupActionType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupActionType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 150;
        data.heightHint = 200;
        configsTable.setLayoutData((Object)data);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionComposite.this.handleTableSelectionChanged();
            }
        });
        this.configsViewer = new TableViewer(configsTable);
        this.configsViewer.setContentProvider((IContentProvider)new ActionContentProvider(this.actions));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator()));
        this.configsViewer.setInput((Object)this);
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        GridData data1 = new GridData(256);
        data1.widthHint = 40;
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActionComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IActionElement) {
                    TitleAreaDialog dialog = null;
                    IActionElement actionElement = (IActionElement)selection.getFirstElement();
                    if (actionElement instanceof Action) {
                        dialog = new ActionPropertiesDialog(ActionComposite.this.parentShell, ActionComposite.this.parentElement, (Action)selection.getFirstElement());
                    } else if (actionElement instanceof BeanAction) {
                        dialog = new BeanActionPropertiesDialog(ActionComposite.this.parentShell, ActionComposite.this.parentElement, (BeanAction)selection.getFirstElement());
                    } else if (actionElement instanceof EvaluateAction) {
                        dialog = new EvaluateActionPropertiesDialog(ActionComposite.this.parentShell, ActionComposite.this.parentElement, (EvaluateAction)selection.getFirstElement());
                    } else if (actionElement instanceof Set) {
                        dialog = new SetActionPropertiesDialog(ActionComposite.this.parentShell, ActionComposite.this.parentElement, (Set)selection.getFirstElement());
                    }
                    if (dialog.open() == 0) {
                        ActionComposite.this.configsViewer.refresh();
                    }
                }
            }
        });
        this.deleteButton = new Button(buttonArea, 8);
        this.deleteButton.setText("Delete");
        data1 = new GridData(256);
        data1.widthHint = 40;
        this.deleteButton.setLayoutData((Object)data1);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActionComposite.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IActionElement) {
                    IActionElement actionElement = (IActionElement)selection.getFirstElement();
                    ActionComposite.this.actions.remove(actionElement);
                    ActionComposite.this.configsViewer.refresh(true);
                }
            }
        });
        Label sep = new Label(buttonArea, 258);
        sep.setLayoutData((Object)data1);
        this.addActionButton = new Button(buttonArea, 8);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.parentElement)) {
            this.addActionButton.setText("Add Action");
        } else {
            this.addActionButton.setText("Add Render");
        }
        data1 = new GridData(256);
        data1.widthHint = 120;
        this.addActionButton.setLayoutData((Object)data1);
        this.addActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Action action = new Action();
                action.createNew(ActionComposite.this.parentElement);
                action.setType(ActionComposite.this.type);
                if (DialogUtils.openPropertiesDialog(ActionComposite.this.parentElement, (IWebflowModelElement)action, true) == 0) {
                    ActionComposite.this.actions.add(action);
                    ActionComposite.this.configsViewer.refresh();
                }
            }
        });
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.parentElement)) {
            this.addBeanActionButton = new Button(buttonArea, 8);
            this.addBeanActionButton.setText("Add Bean Action");
            data1 = new GridData(256);
            data1.widthHint = 120;
            this.addBeanActionButton.setLayoutData((Object)data1);
            this.addBeanActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BeanAction action = new BeanAction();
                    action.createNew(ActionComposite.this.parentElement);
                    action.setType(ActionComposite.this.type);
                    if (DialogUtils.openPropertiesDialog(ActionComposite.this.parentElement, (IWebflowModelElement)action, true) == 0) {
                        ActionComposite.this.actions.add(action);
                        ActionComposite.this.configsViewer.refresh();
                    }
                }
            });
        }
        this.addEvaluationButton = new Button(buttonArea, 8);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.parentElement)) {
            this.addEvaluationButton.setText("Add Evaluation Action");
        } else {
            this.addEvaluationButton.setText("Add Evaluate");
        }
        data1 = new GridData(256);
        data1.widthHint = 120;
        this.addEvaluationButton.setLayoutData((Object)data1);
        this.addEvaluationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EvaluateAction action = new EvaluateAction();
                action.createNew(ActionComposite.this.parentElement);
                action.setType(ActionComposite.this.type);
                if (DialogUtils.openPropertiesDialog(ActionComposite.this.parentElement, (IWebflowModelElement)action, true) == 0) {
                    ActionComposite.this.actions.add(action);
                    ActionComposite.this.configsViewer.refresh();
                }
            }
        });
        this.addSetButton = new Button(buttonArea, 8);
        this.addSetButton.setText("Add Set");
        data1 = new GridData(256);
        data1.widthHint = 120;
        this.addSetButton.setLayoutData((Object)data1);
        this.addSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set action = new Set();
                action.createNew(ActionComposite.this.parentElement);
                action.setType(ActionComposite.this.type);
                if (DialogUtils.openPropertiesDialog(ActionComposite.this.parentElement, (IWebflowModelElement)action, true) == 0) {
                    ActionComposite.this.actions.add(action);
                    ActionComposite.this.configsViewer.refresh();
                }
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        return groupActionType;
    }

    protected void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    public List<IActionElement> getActions() {
        return this.actions;
    }

    private class ActionContentProvider
    implements IStructuredContentProvider {
        private List<IActionElement> actions;

        public ActionContentProvider(List<IActionElement> actions) {
            this.actions = actions;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return this.actions.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

