/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;

public class StateTransitionCreateCommand
extends Command {
    protected ITransitionableFrom source;
    protected ITransitionableTo target;
    protected StateTransition transition;

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        return !(this.source instanceof IEndState) && !(this.source instanceof IDecisionState) && !(this.source instanceof IAttributeMapper) && !(this.source instanceof IActionElement);
    }

    public void execute() {
        this.transition = new StateTransition();
        this.transition.createNew((IWebflowModelElement)this.source, (IWebflowState)this.source.getElementParent());
        this.transition.setOn("*");
        this.transition.setFromState(this.source);
        this.transition.setToState(this.target);
        this.source.addOutputTransition((ITransition)this.transition);
    }

    public ITransitionableFrom getSource() {
        return this.source;
    }

    public ITransitionableTo getTarget() {
        return this.target;
    }

    public ITransition getTransition() {
        return this.transition;
    }

    public void redo() {
        this.source.addOutputTransition((ITransition)this.transition);
        this.target.addInputTransition((ITransition)this.transition);
    }

    public void setSource(ITransitionableFrom activity) {
        this.source = activity;
    }

    public void setTarget(ITransitionableTo activity) {
        this.target = activity;
    }

    public void setTransition(StateTransition transition) {
        this.transition = transition;
    }

    public void undo() {
        this.source.removeOutputTransition((ITransition)this.transition);
        this.target.removeInputTransition((ITransition)this.transition);
    }
}

