/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class CreateAttributeMapperCommand
extends Command {
    private boolean isMove = false;
    private ISubflowState parent;
    private ISubflowState newChild;
    private ISubflowState undoChild;

    public void execute() {
        int result = 0;
        if (!this.isMove) {
            result = DialogUtils.openPropertiesDialog((IWebflowModelElement)this.parent.getElementParent(), (IWebflowModelElement)this.newChild, true, 1);
        }
        if (result == 0) {
            IWebflowModelElement tempChild = ((ICloneableModelElement)this.newChild).cloneModelElement();
            ((ICloneableModelElement)this.parent).applyCloneValues(tempChild);
        }
    }

    public void setMove(boolean isMove) {
        this.isMove = isMove;
    }

    public void setParent(ISubflowState sa) {
        this.parent = sa;
        this.newChild = (ISubflowState)((ICloneableModelElement)this.parent).cloneModelElement();
        this.undoChild = (ISubflowState)((ICloneableModelElement)this.parent).cloneModelElement();
    }

    public void undo() {
        IWebflowModelElement tempChild = ((ICloneableModelElement)this.undoChild).cloneModelElement();
        ((ICloneableModelElement)this.parent).applyCloneValues(tempChild);
    }

    public void redo() {
        boolean tempMove = this.isMove;
        this.isMove = true;
        this.execute();
        this.isMove = tempMove;
    }
}

