/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.webflow.ui.graph.Activator;

public class WebflowImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.webflow.ui.graph.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.webflow.ui.graph.".length();
    private static URL ICON_BASE_URL = null;
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_EXPORT_ENABLED = "org.springframework.ide.eclipse.webflow.ui.graph.export_wiz_obj.gif";
    public static final String IMG_OBJS_EXPORT_DISABLED = "org.springframework.ide.eclipse.webflow.ui.graph.export_wiz.gif";
    public static final String IMG_OBJS_CONNECTION = "org.springframework.ide.eclipse.webflow.ui.graph.connection16.gif";
    public static final String IMG_OBJS_ELSE_CONNECTION = "org.springframework.ide.eclipse.webflow.ui.graph.connection_d16.gif";
    public static final String IMG_OBJS_OUTLINE = "org.springframework.ide.eclipse.webflow.ui.graph.outline.gif";
    public static final String IMG_OBJS_OVERVIEW = "org.springframework.ide.eclipse.webflow.ui.graph.overview.gif";
    public static final String IMG_OBJS_JAVABEAN = "org.springframework.ide.eclipse.webflow.ui.graph.javabean.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_EXPORT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_EXPORT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_CONNECTION;
    public static final ImageDescriptor DESC_OBJS_ELSE_CONNECTION;
    public static final ImageDescriptor DESC_OBJS_OUTLINE;
    public static final ImageDescriptor DESC_OBJS_OVERVIEW;
    public static final ImageDescriptor DESC_OBJS_JAVABEAN;

    static {
        try {
            ICON_BASE_URL = new URL(Activator.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        DESC_OBJS_EXPORT_ENABLED = WebflowImages.createManaged(OBJECT, IMG_OBJS_EXPORT_ENABLED);
        DESC_OBJS_EXPORT_DISABLED = WebflowImages.createManaged(OBJECT, IMG_OBJS_EXPORT_DISABLED);
        DESC_OBJS_CONNECTION = WebflowImages.createManaged(OBJECT, IMG_OBJS_CONNECTION);
        DESC_OBJS_ELSE_CONNECTION = WebflowImages.createManaged(OBJECT, IMG_OBJS_ELSE_CONNECTION);
        DESC_OBJS_OUTLINE = WebflowImages.createManaged(OBJECT, IMG_OBJS_OUTLINE);
        DESC_OBJS_OVERVIEW = WebflowImages.createManaged(OBJECT, IMG_OBJS_OVERVIEW);
        DESC_OBJS_JAVABEAN = WebflowImages.createManaged(OBJECT, IMG_OBJS_JAVABEAN);
    }

    public static Image getImage(String key) {
        return WebflowImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        WebflowImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        WebflowImages.setImageDescriptors(action, "lcl16", iconName);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            for (String key : imageDescriptors.keySet()) {
                imageRegistry.put(key, (ImageDescriptor)imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)WebflowImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        action.setImageDescriptor(WebflowImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)WebflowImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap();
            }
            imageDescriptors.put(name, result);
            if (imageRegistry != null) {
                Activator.log("Image registry already defined", null);
            }
            return result;
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)WebflowImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            Activator.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

