/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.ui.live.LiveBeansUiPlugin;

public class JdtUtils {
    public static IJavaProject getJavaProject(IProject project) {
        if (project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                }
            }
            catch (CoreException e) {
                LiveBeansUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.live", "Error getting Java project for project '" + project.getName() + "'", (Throwable)e));
            }
        }
        return null;
    }

    public static IType getJavaType(IProject project, String className) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (className != null) {
            int pos = className.lastIndexOf(36);
            if (pos > 0) {
                className = className.replace('$', '.');
            }
            try {
                IType type = null;
                if (javaProject != null && (type = javaProject.findType(className, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    return type;
                }
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    IJavaProject refJavaProject = JdtUtils.getJavaProject(refProject);
                    if (refJavaProject != null && (type = refJavaProject.findType(className)) != null) {
                        return type;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                LiveBeansUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.ui.live", "Error getting Java type '" + className + "'", (Throwable)e));
            }
        }
        return null;
    }
}

