/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeanRelation;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeanType;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansContext;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansGroup;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansResource;

public abstract class AbstractLiveBeansTreeContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LiveBeansGroup) {
            LiveBeansGroup group = (LiveBeansGroup)parentElement;
            if (group instanceof LiveBeansContext || group instanceof LiveBeansResource) {
                ArrayList<LiveBean> sortedBeans = new ArrayList<LiveBean>(group.getElements());
                sortedBeans.sort((a, b) -> a.getDisplayName().compareToIgnoreCase(b.getDisplayName()));
                return sortedBeans.toArray(new LiveBean[sortedBeans.size()]);
            }
            return group.getElements().toArray();
        }
        if (parentElement instanceof LiveBean) {
            LiveBean bean = (LiveBean)parentElement;
            return this.getBeanChildren(bean).toArray();
        }
        return null;
    }

    protected List<Object> getBeanChildren(LiveBean bean) {
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new LiveBeanType(bean));
        children.add(new LiveBeansGroup("Dependencies", bean.getDependencies().stream().map(b -> new LiveBeanRelation((LiveBean)b, true)).collect(Collectors.toList())));
        children.add(new LiveBeansGroup("Injected Into", bean.getInjectedInto().stream().map(b -> new LiveBeanRelation((LiveBean)b)).collect(Collectors.toList())));
        return children;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof LiveBeansGroup) {
            return !((LiveBeansGroup)element).getElements().isEmpty();
        }
        return element instanceof LiveBean;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

