/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansJsonParser;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;

public class LiveBeansJsonParser2
extends LiveBeansJsonParser {
    public LiveBeansJsonParser2(TypeLookup typeLookup, String jsonInput) {
        super(typeLookup, jsonInput);
    }

    @Override
    protected JSONArray extractContextsJson(String json) throws JSONException {
        JSONObject contextsObj = new JSONObject(json);
        if (contextsObj.has("contexts")) {
            JSONObject contextsMap = contextsObj.getJSONObject("contexts");
            String[] contextIds = JSONObject.getNames((JSONObject)contextsMap);
            ArrayList<JSONObject> contextsList = new ArrayList<JSONObject>(contextIds.length);
            String[] stringArray = contextIds;
            int n = contextIds.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (contextId instanceof String) {
                    JSONObject contextJson = contextsMap.getJSONObject(contextId);
                    contextJson.put("contextId", (Object)contextId);
                    contextsList.add(contextJson);
                }
                ++n2;
            }
            return new JSONArray(contextsList);
        }
        Object obj = new JSONTokener(json).nextValue();
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        return new JSONArray(Arrays.asList(obj));
    }

    @Override
    protected String getContextId(JSONObject contextJson) throws JSONException {
        return contextJson.getString("contextId");
    }

    @Override
    protected JSONArray extractBeans(JSONObject contextJson) {
        JSONObject obj = contextJson.optJSONObject("beans");
        Iterable iterable = () -> obj.keys();
        return new JSONArray((Collection)StreamSupport.stream(iterable.spliterator(), false).map(k -> {
            try {
                JSONObject jsonBean = obj.getJSONObject(k);
                jsonBean.put("bean", k);
                return jsonBean;
            }
            catch (JSONException jSONException) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

