/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.live.actions;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.springframework.ide.eclipse.beans.ui.live.actions.AbstractOpenResourceAction;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.live.model.TypeLookup;

public class OpenBeanDefinitionAction
extends AbstractOpenResourceAction {
    public OpenBeanDefinitionAction() {
        super("Open Bean Definition File");
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        List elements = selection.toList();
        for (Object obj : elements) {
            String resourcePath;
            if (!(obj instanceof LiveBean)) continue;
            LiveBean bean = (LiveBean)obj;
            TypeLookup session = bean.getTypeLookup();
            String resource = bean.getResource();
            if (resource == null || resource.trim().length() <= 0 || resource.equalsIgnoreCase("null") || !(resourcePath = this.extractResourcePath(resource)).endsWith(".class")) continue;
            this.openInEditor(session, this.extractClassName(resourcePath));
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            List elements = selection.toList();
            for (Object obj : elements) {
                LiveBean bean;
                String resource;
                if (!(obj instanceof LiveBean) || (resource = (bean = (LiveBean)obj).getResource()) == null || resource.trim().length() <= 0 || resource.equalsIgnoreCase("null")) continue;
                return true;
            }
        }
        return false;
    }
}

