/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.resources.LocalFile;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNMoveDeleteHook
implements IMoveDeleteHook {
    private static Set<IFile> deletedFiles = new HashSet<IFile>();
    private static final List<String> deferFileDeleteFilterList = new ArrayList<String>();

    static {
        deferFileDeleteFilterList.add("DeferFileDelete");
    }

    private void deleteResource(ISVNLocalResource resource) throws SVNException {
        ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
        try {
            try {
                svnClient.remove(new File[]{resource.getResource().getLocation().toFile()}, true);
            }
            catch (SVNClientException e) {
                throw new SVNException(4, -6, e.getMessage(), e);
            }
        }
        finally {
            resource.getRepository().returnSVNClient(svnClient);
        }
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)file)) {
            return false;
        }
        LocalFile resource = new LocalFile(file);
        try {
            if (!resource.isManaged()) {
                return false;
            }
            if (this.getDeferFileDelete((IResource)file)) {
                return false;
            }
            try {
                monitor.beginTask(null, 1000);
                deletedFiles.add(file);
                this.deleteResource(resource);
                tree.deletedFile(file);
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public static boolean isDeleted(IFile file) {
        return deletedFiles.contains(file);
    }

    public static void removeFromDeletedFileList(IFile file) {
        deletedFiles.remove(file);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)folder)) {
            return false;
        }
        LocalFolder resource = new LocalFolder((IContainer)folder);
        try {
            if (!resource.isManaged()) {
                return false;
            }
            try {
                monitor.beginTask(null, 1000);
                this.deleteResource(resource);
                tree.deletedFolder(folder);
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)source)) {
            return false;
        }
        try {
            RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)destination.getProject());
            if (repositoryProvider == null || !(repositoryProvider instanceof SVNTeamProvider)) {
                return false;
            }
            LocalFile resource = new LocalFile(source);
            if (!resource.isManaged()) {
                return false;
            }
            ISVNRepositoryLocation sourceRepository = resource.getRepository();
            ISVNClientAdapter svnClient = sourceRepository.getSVNClient();
            ISVNLocalResource parent = SVNWorkspaceRoot.getSVNResourceFor((IResource)destination.getParent());
            ISVNRepositoryLocation targetRepository = parent.getRepository();
            if (!sourceRepository.equals(targetRepository)) {
                return false;
            }
            try {
                monitor.beginTask(null, 1000);
                try {
                    try {
                        OperationManager.getInstance().beginOperation(svnClient);
                        if (!SVNWorkspaceRoot.getSVNFolderFor(destination.getParent()).isManaged()) {
                            SVNTeamProvider provider = (SVNTeamProvider)repositoryProvider;
                            provider.add(new IResource[]{destination.getParent()}, 0, (IProgressMonitor)new NullProgressMonitor());
                            if (parent != null) {
                                parent.refreshStatus();
                            }
                        }
                        svnClient.move(source.getLocation().toFile(), destination.getLocation().toFile(), true);
                        tree.movedFile(source, destination);
                        destination.refreshLocal(0, monitor);
                    }
                    catch (SVNClientException e) {
                        throw SVNException.wrapException((Exception)((Object)e));
                    }
                    catch (TeamException e) {
                        throw SVNException.wrapException(e);
                    }
                    catch (CoreException e) {
                        throw SVNException.wrapException(e);
                    }
                }
                finally {
                    resource.getRepository().returnSVNClient(svnClient);
                    OperationManager.getInstance().endOperation(false, null, false);
                }
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)source)) {
            return false;
        }
        try {
            ISVNLocalResource parent;
            ISVNRepositoryLocation targetRepository;
            LocalFolder resource = new LocalFolder((IContainer)source);
            if (!resource.isManaged()) {
                return false;
            }
            RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)destination.getProject());
            if (repositoryProvider == null || !(repositoryProvider instanceof SVNTeamProvider)) {
                return false;
            }
            ISVNRepositoryLocation sourceRepository = resource.getRepository();
            if (!sourceRepository.equals(targetRepository = (parent = SVNWorkspaceRoot.getSVNResourceFor((IResource)destination.getParent())).getRepository())) {
                return false;
            }
            try {
                monitor.beginTask(null, 1000);
                ISVNClientAdapter svnClient = sourceRepository.getSVNClient();
                try {
                    try {
                        OperationManager.getInstance().beginOperation(svnClient);
                        if (!SVNWorkspaceRoot.getSVNFolderFor(destination.getParent()).isManaged()) {
                            SVNTeamProvider provider = (SVNTeamProvider)repositoryProvider;
                            provider.add(new IResource[]{destination.getParent()}, 0, (IProgressMonitor)new NullProgressMonitor());
                            if (parent != null) {
                                parent.refreshStatus();
                            }
                        }
                        svnClient.move(source.getLocation().toFile(), destination.getLocation().toFile(), true);
                        tree.movedFolderSubtree(source, destination);
                        destination.refreshLocal(2, monitor);
                    }
                    catch (SVNClientException e) {
                        throw SVNException.wrapException((Exception)((Object)e));
                    }
                    catch (CoreException e) {
                        throw SVNException.wrapException(e);
                    }
                }
                finally {
                    resource.getRepository().returnSVNClient(svnClient);
                    OperationManager.getInstance().endOperation(false);
                }
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        block11: {
            File databaseFile;
            block10: {
                File metaFolder;
                block9: {
                    block8: {
                        LocalFolder resource;
                        block7: {
                            resource = new LocalFolder((IContainer)project);
                            try {
                                if ((updateFlags & 8) != 8) break block7;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (resource.isManaged()) break block8;
                        return false;
                    }
                    File projectDirectory = new File(project.getLocationURI());
                    metaFolder = new File(projectDirectory, ".svn");
                    if (metaFolder.exists()) break block9;
                    return false;
                }
                databaseFile = new File(metaFolder, "wc.db");
                if (databaseFile.exists()) break block10;
                return false;
            }
            if (!databaseFile.delete()) break block11;
            return false;
        }
        SVNProviderPlugin.handleMessage(Policy.bind("SVNMoveDeleteHook.4"), String.valueOf(Policy.bind("SVNMoveDeleteHook.5")) + project.getName() + Policy.bind("SVNMoveDeleteHook.6"), 2);
        return true;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    private boolean getDeferFileDelete(IResource resource) {
        ISVNLocalResource parent;
        block5: {
            ISVNLocalResource svnResource;
            parent = svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
            try {
                while (parent != null) {
                    if (parent.isManaged()) break;
                    parent = parent.getParent();
                }
                if (parent != null && parent.isManaged()) break block5;
                return false;
            }
            catch (SVNException sVNException) {
                return false;
            }
        }
        ISVNProperty[] deferFileDeleteProperties = parent.getPropertiesIncludingInherited(false, true, deferFileDeleteFilterList);
        if (deferFileDeleteProperties != null && deferFileDeleteProperties.length > 0) {
            return deferFileDeleteProperties[0].getValue().equalsIgnoreCase("true");
        }
        return false;
    }
}

