/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public abstract class RemoteResource
extends CachedResourceVariant
implements ISVNRemoteResource {
    protected RemoteFolder parent;
    protected SVNUrl url;
    protected ISVNRepositoryLocation repository;
    protected SVNRevision revision;
    protected SVNRevision.Number lastChangedRevision;
    protected Date date;
    protected String author;
    protected SVNRevision pegRevision;

    public RemoteResource(IResource local, byte[] bytes) {
        String nfo = new String(bytes);
        this.lastChangedRevision = new SVNRevision.Number(Long.parseLong(nfo));
        this.revision = this.lastChangedRevision;
        ISVNLocalResource res = SVNWorkspaceRoot.getSVNResourceFor(local);
        this.url = res.getUrl();
        this.repository = res.getRepository();
    }

    public RemoteResource(RemoteFolder parent, ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision, SVNRevision.Number lastChangedRevision, Date date, String author) {
        this.parent = parent;
        this.repository = repository;
        this.url = url;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.date = date;
        this.author = author;
    }

    public RemoteResource(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        this.parent = null;
        this.repository = repository;
        this.url = url;
        this.revision = revision;
        this.lastChangedRevision = null;
        this.date = null;
        this.author = null;
    }

    @Override
    public String getName() {
        return this.url != null ? this.url.getLastPathSegment() : "";
    }

    @Override
    public String getRepositoryRelativePath() {
        return SVNUrlUtils.getRelativePath((SVNUrl)this.getRepository().getUrl(), (SVNUrl)this.getUrl(), (boolean)true);
    }

    @Override
    public String getProjectRelativePath() {
        ISVNRemoteResource project = this;
        while (project.getParent() != null) {
            project = project.getParent();
        }
        return SVNUrlUtils.getRelativePath((SVNUrl)project.getUrl(), (SVNUrl)this.getUrl(), (boolean)false);
    }

    @Override
    public boolean exists(IProgressMonitor monitor) throws TeamException {
        return this.parent.exists(this, monitor);
    }

    @Override
    public ISVNRemoteFolder getParent() {
        return this.parent;
    }

    @Override
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RemoteResource)) {
            return false;
        }
        RemoteResource remote = (RemoteResource)target;
        return remote.isContainer() == this.isContainer() && remote.getUrl().equals((Object)this.getUrl()) && remote.getRevision() == this.getRevision();
    }

    public int hashCode() {
        return this.getUrl().hashCode() + this.getRevision().hashCode();
    }

    @Override
    public ISVNRepositoryLocation getRepository() {
        return this.repository;
    }

    @Override
    public SVNUrl getUrl() {
        return this.url;
    }

    @Override
    public SVNRevision.Number getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    @Override
    public SVNRevision getRevision() {
        return this.revision;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public SVNRevision getPegRevision() {
        return this.pegRevision;
    }

    public void setPegRevision(SVNRevision pegRevision) {
        this.pegRevision = pegRevision;
    }

    public String getContentIdentifier() {
        if (this.getLastChangedRevision() == null) {
            if (this.revision == null) {
                return "";
            }
            return this.revision.toString();
        }
        return String.valueOf(this.getLastChangedRevision().getNumber());
    }

    protected String getCachePath() {
        return String.valueOf(this.getUrl().toString()) + ":" + this.getContentIdentifier();
    }

    protected String getCacheId() {
        return "org.tigris.subversion.subclipse.core";
    }

    public byte[] asBytes() {
        return new Long(this.getContentIdentifier()).toString().getBytes();
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws TeamException {
        ISVNClientAdapter svnClient = this.repository.getSVNClient();
        try {
            ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(this.getUrl(), pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions);
            return iSVNLogMessageArray;
        }
        catch (SVNClientException e) {
            throw new TeamException("Failed in RemoteResource.getLogMessages()", (Throwable)e);
        }
        finally {
            this.repository.returnSVNClient(svnClient);
        }
    }

    public String toString() {
        return this.getCachePath();
    }
}

