/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.AddResourcesCommand;
import org.tigris.subversion.subclipse.core.commands.CheckinResourcesCommand;
import org.tigris.subversion.subclipse.core.commands.SwitchToUrlCommand;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNFileModificationValidator;
import org.tigris.subversion.subclipse.core.resources.SVNMoveDeleteHook;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNTeamProvider
extends RepositoryProvider {
    private SVNWorkspaceRoot workspaceRoot;
    private static final ResourceRuleFactory RESOURCE_RULE_FACTORY = new ResourceRuleFactory(){};

    public void deconfigure() {
    }

    public void deconfigured() {
        try {
            SVNProviderPlugin.getPlugin().getStatusCacheManager().purgeCache((IContainer)this.getProject(), true);
        }
        catch (SVNException e) {
            SVNProviderPlugin.log(e);
        }
        SVNProviderPlugin.broadcastProjectDeconfigured(this.getProject());
    }

    private void configureTeamPrivateResource(IProject project) {
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 2 && resource.getName().equals(SVNProviderPlugin.getPlugin().getAdminDirectoryName()) && !resource.isTeamPrivateMember()) {
                        resource.setTeamPrivateMember(true);
                        return false;
                    }
                    return true;
                }
            }, 2, 3);
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(SVNException.wrapException(e));
        }
    }

    public void setProject(IProject project) {
        super.setProject(project);
        this.workspaceRoot = new SVNWorkspaceRoot((IContainer)project);
    }

    public void add(IResource[] resources, int depth, IProgressMonitor progress) throws SVNException {
        AddResourcesCommand command = new AddResourcesCommand(this.getSVNWorkspaceRoot(), resources, depth);
        command.run(progress);
    }

    public String checkin(IResource[] resources, String comment, boolean keepLocks, int depth, IProgressMonitor progress) throws TeamException {
        CheckinResourcesCommand command = new CheckinResourcesCommand(this.getSVNWorkspaceRoot(), resources, depth, comment, keepLocks);
        command.run(progress);
        return command.getPostCommitError();
    }

    public void switchToUrl(IResource resource, SVNUrl svnUrl, SVNRevision svnRevision, IProgressMonitor progress) throws TeamException {
        SwitchToUrlCommand command = new SwitchToUrlCommand(this.getSVNWorkspaceRoot(), resource, svnUrl, svnRevision);
        command.run(progress);
    }

    public SVNWorkspaceRoot getSVNWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public void configureProject() {
        this.configureTeamPrivateResource(this.getProject());
        SVNProviderPlugin.broadcastProjectConfigured(this.getProject());
    }

    public String getID() {
        return SVNProviderPlugin.getTypeId();
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new SVNMoveDeleteHook();
    }

    public IFileModificationValidator getFileModificationValidator() {
        return new SVNFileModificationValidator();
    }

    public IResourceVariant getResourceVariant(IResource resource) throws SVNException {
        ISVNLocalResource local = SVNWorkspaceRoot.getSVNResourceFor(resource);
        return local.getLatestRemoteResource();
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (resource.getType() == 1) {
            return new RemoteFile(resource, bytes);
        }
        if (resource.getType() == 2 || resource.getType() == 4) {
            return new RemoteFolder(resource, bytes);
        }
        return null;
    }

    public IResourceRuleFactory getRuleFactory() {
        return RESOURCE_RULE_FACTORY;
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }
}

