/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.ISVNRepositorySourceProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.SynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeParticipant;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardMainPage;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardRepositorySourceProviderPage;
import org.tigris.subversion.subclipse.ui.wizards.SVNRepositoryProviderWizardPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.CannotSharePage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.ConfigurationWizardAutoconnectPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.DirectorySelectionPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.ISVNRepositoryLocationProvider;
import org.tigris.subversion.subclipse.ui.wizards.sharing.RepositorySelectionPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.SharingWizardFinishPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.SvnFoldersExistWarningPage;

public class SharingWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private ConfigurationWizardAutoconnectPage autoconnectPage;
    private SvnFoldersExistWarningPage warningPage;
    private RepositorySelectionPage locationPage;
    private ConfigurationWizardRepositorySourceProviderPage repositorySourceProviderPage;
    private Map<ISVNRepositorySourceProvider, SVNRepositoryProviderWizardPage> wizardPageMap = new HashMap<ISVNRepositorySourceProvider, SVNRepositoryProviderWizardPage>();
    private ConfigurationWizardMainPage createLocationPage;
    private DirectorySelectionPage directoryPage;
    private SharingWizardFinishPage finishPage;
    private LocalResourceStatus projectStatus;
    private ISVNRepositoryLocation[] locations;
    private boolean shareCanceled;
    public static final String METADATA_FOLDER = ".metadata";

    public SharingWizard() {
        IDialogSettings workbenchSettings = SVNUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("SharingWizard.title"));
    }

    public void addPages() {
        ImageDescriptor sharingImage = SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif");
        if (this.project.getLocation() == null) {
            CannotSharePage cannotSharePage = new CannotSharePage("cannotSharePage", Policy.bind("SharingWizard.importTitle"), sharingImage, this.project);
            this.addPage((IWizardPage)cannotSharePage);
        } else if (this.doesSVNDirectoryExist()) {
            this.autoconnectPage = new ConfigurationWizardAutoconnectPage("autoconnectPage", Policy.bind("SharingWizard.autoConnectTitle"), sharingImage, this.projectStatus);
            this.autoconnectPage.setProject(this.project);
            this.autoconnectPage.setDescription(Policy.bind("SharingWizard.autoConnectTitleDescription"));
            this.addPage((IWizardPage)this.autoconnectPage);
        } else {
            try {
                IFolder[] svnFolders;
                ISVNLocalFolder localFolder = SVNWorkspaceRoot.getSVNFolderFor((IContainer)this.project);
                if (localFolder instanceof LocalFolder && (svnFolders = ((LocalFolder)localFolder).getSVNFolders(null, false)).length > 0) {
                    this.warningPage = new SvnFoldersExistWarningPage("warningPage", Policy.bind("SharingWizard.importTitle"), sharingImage, svnFolders);
                    this.warningPage.setDescription(Policy.bind("SharingWizard.svnFolderExists"));
                    this.addPage((IWizardPage)this.warningPage);
                }
            }
            catch (SVNException e) {
                SVNUIPlugin.openError(this.getShell(), null, null, e, 1);
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SharingWizard.this.locations = SVNUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations(monitor);
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, runnable);
            }
            catch (Exception e) {
                SVNUIPlugin.openError(this.getShell(), null, null, e, 2);
            }
            this.locationPage = new RepositorySelectionPage("importPage", Policy.bind("SharingWizard.importTitle"), sharingImage);
            this.locationPage.setDescription(Policy.bind("SharingWizard.importTitleDescription"));
            this.addPage((IWizardPage)this.locationPage);
            ISVNRepositorySourceProvider[] repositorySourceProviders = null;
            try {
                repositorySourceProviders = SVNUIPlugin.getRepositorySourceProviders();
            }
            catch (Exception exception) {}
            if (repositorySourceProviders != null && repositorySourceProviders.length > 0) {
                this.repositorySourceProviderPage = new ConfigurationWizardRepositorySourceProviderPage("source", Policy.bind("NewLocationWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"), repositorySourceProviders);
                this.repositorySourceProviderPage.setDescription(Policy.bind("NewLocationWizard.0"));
                this.addPage((IWizardPage)this.repositorySourceProviderPage);
                ISVNRepositorySourceProvider[] iSVNRepositorySourceProviderArray = repositorySourceProviders;
                int n = repositorySourceProviders.length;
                int n2 = 0;
                while (n2 < n) {
                    ISVNRepositorySourceProvider repositorySourceProvider = iSVNRepositorySourceProviderArray[n2];
                    SVNRepositoryProviderWizardPage wizardPage = repositorySourceProvider.getWizardPage();
                    this.addPage((IWizardPage)wizardPage);
                    this.wizardPageMap.put(repositorySourceProvider, wizardPage);
                    ++n2;
                }
            }
            this.createLocationPage = new ConfigurationWizardMainPage("createLocationPage", Policy.bind("SharingWizard.enterInformation"), sharingImage);
            this.createLocationPage.setDescription(Policy.bind("SharingWizard.enterInformationDescription"));
            this.addPage((IWizardPage)this.createLocationPage);
            this.createLocationPage.setDialogSettings(this.getDialogSettings());
            ISVNRepositoryLocationProvider repositoryLocationProvider = new ISVNRepositoryLocationProvider(){

                @Override
                public ISVNRepositoryLocation getLocation() throws TeamException {
                    return SharingWizard.this.getLocation();
                }

                @Override
                public IProject getProject() {
                    return SharingWizard.this.getProject();
                }
            };
            this.directoryPage = new DirectorySelectionPage("modulePage", Policy.bind("SharingWizard.enterModuleName"), sharingImage, repositoryLocationProvider);
            this.directoryPage.setDescription(Policy.bind("SharingWizard.enterModuleNameDescription"));
            this.addPage((IWizardPage)this.directoryPage);
            this.finishPage = new SharingWizardFinishPage("finishPage", Policy.bind("SharingWizard.readyToFinish"), sharingImage, repositoryLocationProvider);
            this.finishPage.setDescription(Policy.bind("SharingWizard.readyToFinishDescription"));
            this.addPage((IWizardPage)this.finishPage);
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.directoryPage) {
            return this.directoryPage.useProjectName() || this.directoryPage.getDirectoryName() != null;
        }
        if (page == this.finishPage) {
            return true;
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.warningPage) {
            return this.locationPage;
        }
        if (page == this.autoconnectPage) {
            return null;
        }
        if (page == this.locationPage) {
            if (this.locationPage.getLocation() == null) {
                if (this.repositorySourceProviderPage == null) {
                    return this.createLocationPage;
                }
                return this.repositorySourceProviderPage;
            }
            return this.directoryPage;
        }
        if (page == this.repositorySourceProviderPage) {
            ISVNRepositorySourceProvider selectedRepositorySourceProvider = this.repositorySourceProviderPage.getSelectedRepositorySourceProvider();
            if (selectedRepositorySourceProvider != null) {
                return (IWizardPage)this.wizardPageMap.get(selectedRepositorySourceProvider);
            }
            return this.createLocationPage;
        }
        if (page instanceof SVNRepositoryProviderWizardPage) {
            return this.directoryPage;
        }
        if (page == this.createLocationPage) {
            return this.directoryPage;
        }
        if (page == this.directoryPage) {
            return this.finishPage;
        }
        return null;
    }

    public boolean performFinish() {
        boolean[] result;
        block13: {
            boolean[] doSync;
            block12: {
                this.shareCanceled = false;
                if (!WorkspacePathValidator.validateWorkspacePath()) {
                    return true;
                }
                result = new boolean[]{true};
                doSync = new boolean[1];
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        block23: {
                            try {
                                boolean createDirectory;
                                boolean isKnown;
                                ISVNRepositoryLocation location;
                                block24: {
                                    block25: {
                                        monitor.beginTask("", 100);
                                        if (SharingWizard.this.autoconnectPage != null && SharingWizard.this.projectStatus != null) {
                                            block22: {
                                                boolean isPreviouslyKnown = SVNProviderPlugin.getPlugin().getRepositories().isKnownRepository(SharingWizard.this.projectStatus.getUrlString(), false);
                                                boolean validate = SharingWizard.this.autoconnectPage.getValidate();
                                                if (validate && !isPreviouslyKnown) {
                                                    ISVNRepositoryLocation location2 = SVNProviderPlugin.getPlugin().getRepository(SharingWizard.this.projectStatus.getUrlString());
                                                    try {
                                                        location2.validateConnection((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                                    }
                                                    catch (TeamException e) {
                                                        final boolean[] keep = new boolean[1];
                                                        SharingWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                keep[0] = MessageDialog.openQuestion((Shell)SharingWizard.this.getContainer().getShell(), (String)Policy.bind("SharingWizard.validationFailedTitle"), (String)Policy.bind("SharingWizard.validationFailedText", new Object[]{e.getStatus().getMessage()}));
                                                            }
                                                        });
                                                        if (keep[0]) break block22;
                                                        try {
                                                            if (!isPreviouslyKnown) {
                                                                SVNProviderPlugin.getPlugin().getRepositories().disposeRepository(location2);
                                                            }
                                                        }
                                                        catch (TeamException e1) {
                                                            SVNUIPlugin.openError(SharingWizard.this.getContainer().getShell(), Policy.bind("exception"), null, e1, 1);
                                                        }
                                                        result[0] = false;
                                                        monitor.done();
                                                        return;
                                                    }
                                                }
                                            }
                                            SVNWorkspaceRoot.setSharing((IProject)SharingWizard.this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                            break block23;
                                        }
                                        doSync[0] = true;
                                        location = null;
                                        isKnown = false;
                                        createDirectory = true;
                                        try {
                                            location = SharingWizard.this.getLocation();
                                            isKnown = SVNProviderPlugin.getPlugin().getRepositories().isKnownRepository(location.getLocation(), false);
                                            SVNWorkspaceRoot.getSVNFolderFor((IContainer)SharingWizard.this.project).unmanage(null);
                                            String remoteDirectoryName = SharingWizard.this.getRemoteDirectoryName();
                                            ISVNRemoteFolder folder = location.getRemoteFolder(remoteDirectoryName);
                                            if (!folder.exists((IProgressMonitor)new SubProgressMonitor(monitor, 50))) break block24;
                                            if (SharingWizard.this.autoconnectPage != null) break block25;
                                            SharingWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (!MessageDialog.openQuestion((Shell)SharingWizard.this.getShell(), (String)Policy.bind("SharingWizard.couldNotImport"), (String)Policy.bind("SharingWizard.couldNotImportLong"))) {
                                                        SharingWizard.this.shareCanceled = true;
                                                        return;
                                                    }
                                                }
                                            });
                                            if (!SharingWizard.this.shareCanceled) break block25;
                                            return;
                                        }
                                        catch (TeamException e) {
                                            SVNUIPlugin.openError(SharingWizard.this.getShell(), null, null, e, 1);
                                            result[0] = false;
                                            doSync[0] = false;
                                            monitor.done();
                                            return;
                                        }
                                    }
                                    createDirectory = false;
                                }
                                try {
                                    if (!isKnown) {
                                        SVNProviderPlugin.getPlugin().getRepositories().addOrUpdateRepository(location);
                                    }
                                    SVNWorkspaceRoot.shareProject((ISVNRepositoryLocation)location, (IProject)SharingWizard.this.project, (String)SharingWizard.this.getRemoteDirectoryName(), (String)SharingWizard.this.finishPage.getComment(), (boolean)createDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    try {
                                        SharingWizard.this.project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    }
                                    catch (CoreException ce) {
                                        throw new TeamException(ce.getStatus());
                                    }
                                    ArrayList files = new ArrayList();
                                    SharingWizard.this.collectProjectFilesFromDirectory(files, SharingWizard.this.project.getLocation().toFile(), null, monitor);
                                    for (File file : files) {
                                        IResource resource = File2Resource.getResource((File)file.getParentFile());
                                        IProject childProject = resource.getProject();
                                        if (childProject.equals((Object)SharingWizard.this.project)) continue;
                                        RepositoryProvider.map((IProject)childProject, (String)SVNProviderPlugin.getTypeId());
                                    }
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    }
                });
                if (!this.shareCanceled) break block12;
                return false;
            }
            try {
                ArrayList<Object> syncList;
                block14: {
                    if (!doSync[0]) break block13;
                    syncList = new ArrayList<Object>();
                    syncList.add(this.project);
                    try {
                        ISynchronizeParticipantReference[] references = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
                        if (references == null) break block14;
                        int i = 0;
                        while (i < references.length) {
                            ISynchronizeParticipantReference reference = references[i];
                            ISynchronizeParticipant participant = reference.getParticipant();
                            if (participant instanceof SVNSynchronizeParticipant) {
                                SVNSynchronizeParticipant svnParticipant = (SVNSynchronizeParticipant)participant;
                                IResource[] resources = svnParticipant.getResources();
                                if (resources != null) {
                                    int j = 0;
                                    while (j < resources.length) {
                                        IResource resource = resources[j];
                                        if (!resource.equals((Object)this.project)) {
                                            syncList.add(resource);
                                        }
                                        ++j;
                                    }
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception exception) {}
                }
                SynchronizeAction synchronizeAction = new SynchronizeAction(){

                    @Override
                    protected IResource[] getSelectedResources() {
                        IResource[] selection = new IResource[syncList.size()];
                        syncList.toArray(selection);
                        return selection;
                    }
                };
                synchronizeAction.run(null);
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.openError(this.getContainer().getShell(), null, null, e);
                return false;
            }
        }
        return result[0];
    }

    protected ISVNRepositoryLocation getLocation() throws TeamException {
        SVNRepositoryProviderWizardPage wizardPage;
        ISVNRepositorySourceProvider selectedRepositorySourceProvider;
        ISVNRepositoryLocation location;
        if (this.autoconnectPage != null) {
            return this.autoconnectPage.getLocation();
        }
        if (this.locationPage != null && (location = this.locationPage.getLocation()) != null) {
            return location;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SharingWizard.this.createLocationPage.finish((IProgressMonitor)new NullProgressMonitor());
            }
        });
        final Properties properties = this.createLocationPage.getProperties();
        if (this.repositorySourceProviderPage != null && (selectedRepositorySourceProvider = this.repositorySourceProviderPage.getSelectedRepositorySourceProvider()) != null && (wizardPage = this.wizardPageMap.get(selectedRepositorySourceProvider)) != null) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    properties.setProperty("url", wizardPage.getSelectedUrl());
                }
            });
        }
        ISVNRepositoryLocation location2 = SVNProviderPlugin.getPlugin().getRepositories().createRepository(properties);
        return location2;
    }

    private String getRemoteDirectoryName() {
        if (this.autoconnectPage != null) {
            return Util.getLastSegment((String)this.autoconnectPage.getSharingStatus().getUrlString());
        }
        String moduleName = this.directoryPage.getDirectoryName();
        if (moduleName == null) {
            moduleName = this.project.getName();
        }
        return moduleName;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
    }

    private boolean doesSVNDirectoryExist() {
        boolean isSVNFolder = false;
        try {
            this.projectStatus = SVNWorkspaceRoot.peekResourceStatusFor((IResource)this.project);
            isSVNFolder = this.projectStatus != null && this.projectStatus.hasRemote();
        }
        catch (SVNException e) {
            Shell shell = null;
            if (this.getContainer() != null) {
                shell = this.getContainer().getShell();
            }
            SVNUIPlugin.openError(shell, null, null, e);
        }
        return isSVNFolder;
    }

    public IProject getProject() {
        return this.project;
    }

    private boolean collectProjectFilesFromDirectory(Collection<File> files, File directory, Set<String> directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                SVNUIPlugin.openError(this.getShell(), null, null, exception, 1);
            }
        }
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
            }
            ++i;
        }
        i = 0;
        while (i < contents.length) {
            block12: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block11: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException exception) {
                            SVNUIPlugin.openError(this.getShell(), null, null, exception, 1);
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }
}

