/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.CompareDialog;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTree;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnWizardRevertPage
extends SvnWizardDialogPage {
    private IResource[] resourcesToRevert;
    private Object[] selectedResources;
    private HashMap statusMap;
    private ResourceSelectionTree resourceSelectionTree;
    private boolean resourceRemoved;
    private Button includeUnversionedButton;
    private boolean includeUnversioned;
    private boolean fromSyncView;

    public SvnWizardRevertPage(IResource[] resourcesToRevert, String url, HashMap statusMap, boolean fromSyncView) {
        super("RevertDialog", Policy.bind("RevertDialog.title"));
        this.fromSyncView = fromSyncView;
        this.includeUnversioned = fromSyncView ? true : SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_select_unadded_resources_on_commit");
        this.resourcesToRevert = resourcesToRevert;
        this.statusMap = statusMap;
    }

    @Override
    public void createControls(Composite outerContainer) {
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ResourceSelectionTree.IToolbarControlCreator toolbarControlCreator = new ResourceSelectionTree.IToolbarControlCreator(){

            @Override
            public void createToolbarControls(ToolBarManager toolbarManager) {
                toolbarManager.add((IContributionItem)new ControlContribution("ignoreUnversioned"){

                    protected Control createControl(Composite parent) {
                        SvnWizardRevertPage.this.includeUnversionedButton = new Button(parent, 32);
                        SvnWizardRevertPage.this.includeUnversionedButton.setText(Policy.bind("CommitDialog.includeUnversioned"));
                        SvnWizardRevertPage.this.includeUnversionedButton.setSelection(SvnWizardRevertPage.this.includeUnversioned);
                        SvnWizardRevertPage.this.includeUnversionedButton.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                SvnWizardRevertPage.this.includeUnversioned = SvnWizardRevertPage.this.includeUnversionedButton.getSelection();
                                if (!SvnWizardRevertPage.this.includeUnversioned) {
                                    SvnWizardRevertPage.this.resourceSelectionTree.removeUnversioned();
                                } else {
                                    SvnWizardRevertPage.this.resourceSelectionTree.addUnversioned();
                                }
                                SvnWizardRevertPage.this.selectedResources = SvnWizardRevertPage.this.resourceSelectionTree.getSelectedResources();
                                SvnWizardRevertPage.this.setPageComplete(SvnWizardRevertPage.this.canFinish());
                                if (!SvnWizardRevertPage.this.fromSyncView) {
                                    SvnWizardRevertPage.this.updatePreference(SvnWizardRevertPage.this.includeUnversioned);
                                }
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        return SvnWizardRevertPage.this.includeUnversionedButton;
                    }
                });
            }

            @Override
            public int getControlCount() {
                return 1;
            }
        };
        IResource[] dedupedResourcesToRevert = ResourceSelectionTree.dedupeResources(this.resourcesToRevert);
        if (dedupedResourcesToRevert.length != this.resourcesToRevert.length) {
            this.resourceRemoved = true;
        }
        this.resourceSelectionTree = new ResourceSelectionTree(composite, 0, Policy.bind("GenerateSVNDiff.Changes"), dedupedResourcesToRevert, this.statusMap, null, true, toolbarControlCreator, null);
        if (!this.resourceSelectionTree.showIncludeUnversionedButton()) {
            this.includeUnversionedButton.setVisible(false);
        }
        this.resourceSelectionTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SvnWizardRevertPage.this.selectedResources = SvnWizardRevertPage.this.resourceSelectionTree.getSelectedResources();
            }
        });
        ((CheckboxTreeViewer)this.resourceSelectionTree.getTreeViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SvnWizardRevertPage.this.selectedResources = SvnWizardRevertPage.this.resourceSelectionTree.getSelectedResources();
            }
        });
        this.resourceSelectionTree.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object sel0 = sel.getFirstElement();
                if (sel0 instanceof IFile) {
                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                    try {
                        new CompareDialog(SvnWizardRevertPage.this.getShell(), new SVNLocalCompareInput(localResource, SVNRevision.BASE, true)).open();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        if (!this.includeUnversioned) {
            this.resourceSelectionTree.removeUnversioned();
        }
        this.resourceSelectionTree.getTreeViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectedResources = this.resourceSelectionTree.getSelectedResources();
        this.setPageComplete(this.canFinish());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.revert_dialog_context");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performFinish() {
        if (!this.resourceRemoved) {
            this.resourceRemoved = this.resourceSelectionTree.isResourceRemoved();
        }
        return true;
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("RevertDialog.resources"));
    }

    @Override
    public void saveSettings() {
    }

    public IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return this.resourcesToRevert;
        }
        List<Object> result = Arrays.asList(this.selectedResources);
        return result.toArray(new IResource[result.size()]);
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("RevertDialog.title");
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    public void setResourceRemoved(boolean resourceRemoved) {
        this.resourceRemoved = resourceRemoved;
    }

    public boolean isResourceRemoved() {
        return this.resourceRemoved;
    }

    public void updatePreference(boolean includeUnversioned) {
        SVNUIPlugin.getPlugin().getPreferenceStore().setValue("pref_select_unadded_resources_on_commit", includeUnversioned);
    }

    private boolean canFinish() {
        return this.selectedResources.length > 0;
    }
}

