/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.RevertSynchronizeOperation;

public class RevertSynchronizeAction
extends SynchronizeModelAction {
    private String url;
    private HashMap statusMap;

    public RevertSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                FastSyncInfoFilter.SyncInfoDirectionFilter outgoingFilter = new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
                if (!outgoingFilter.select(info)) {
                    return false;
                }
                IStructuredSelection selection = RevertSynchronizeAction.this.getStructuredSelection();
                Iterator iter = selection.iterator();
                boolean removeUnAdded = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
                while (iter.hasNext()) {
                    ISynchronizeModelElement element = (ISynchronizeModelElement)iter.next();
                    IResource resource = element.getResource();
                    if (resource == null) continue;
                    if (resource.isLinked()) {
                        return false;
                    }
                    if (removeUnAdded) continue;
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    try {
                        if (svnResource.isManaged()) continue;
                        return false;
                    }
                    catch (SVNException sVNException) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IResource[] topSelectionArray;
        ISynchronizeModelElement element;
        IResource resource;
        this.statusMap = new HashMap();
        this.url = null;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() == 1 && (resource = (element = (ISynchronizeModelElement)selection.getFirstElement()).getResource()) != null) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            try {
                this.url = svnResource.getStatus().getUrlString();
                if (this.url == null || resource.getType() == 1) {
                    this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
                }
            }
            catch (SVNException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
        ArrayList<IResource> selectedResources = new ArrayList<IResource>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ISynchronizeModelElement) {
                selectedResources.add(((ISynchronizeModelElement)elements[i]).getResource());
            }
            ++i;
        }
        IResource[] resources = new IResource[selectedResources.size()];
        selectedResources.toArray(resources);
        boolean changeSetMode = this.isChangeSetMode();
        ArrayList<IResource> topSelection = new ArrayList<IResource>();
        if (!changeSetMode) {
            for (ISynchronizeModelElement element2 : selection) {
                topSelection.add(element2.getResource());
            }
        }
        if (changeSetMode) {
            topSelectionArray = resources;
        } else {
            topSelectionArray = new IResource[topSelection.size()];
            topSelection.toArray(topSelectionArray);
        }
        RevertSynchronizeOperation revertOperation = new RevertSynchronizeOperation(configuration, elements, this.url, resources, this.statusMap);
        revertOperation.setSelectedResources(topSelectionArray);
        return revertOperation;
    }

    private boolean isChangeSetMode() {
        Viewer viewer = this.getConfiguration().getPage().getViewer();
        if (viewer instanceof TreeViewer) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = ((TreeViewer)viewer).getTree().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof ChangeSetDiffNode) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

