/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.CleanupResourcesCommand;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ReplaceWithRemoteOperation
extends RepositoryProviderOperation {
    private IResource resource;
    private SVNUrl url;
    private SVNRevision revision;

    public ReplaceWithRemoteOperation(IWorkbenchPart part, IResource resource, SVNUrl url, SVNRevision revision) {
        super(part, new IResource[]{resource});
        this.resource = resource;
        this.url = url;
        this.revision = revision;
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("ReplaceWithRemoteOperation.0");
    }

    @Override
    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("ReplaceWithRemoteOperation.0");
    }

    @Override
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        ISVNClientAdapter client = provider.getSVNWorkspaceRoot().getRepository().getSVNClient();
        try {
            try {
                File[] files = new File[]{resources[0].getLocation().toFile()};
                client.remove(files, true);
                client.copy(this.url, files[0], this.revision);
            }
            catch (Exception e) {
                throw SVNException.wrapException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            try {
                this.resource.refreshLocal(5, monitor);
                if (this.resource instanceof IContainer) {
                    CleanupResourcesCommand command = new CleanupResourcesCommand(provider.getSVNWorkspaceRoot(), resources);
                    command.run(Policy.subMonitorFor(monitor, 100));
                }
            }
            catch (CoreException coreException) {}
            monitor.done();
            throw throwable;
        }
        try {
            this.resource.refreshLocal(5, monitor);
            if (this.resource instanceof IContainer) {
                CleanupResourcesCommand command = new CleanupResourcesCommand(provider.getSVNWorkspaceRoot(), resources);
                command.run(Policy.subMonitorFor(monitor, 100));
            }
        }
        catch (CoreException coreException) {}
        monitor.done();
    }
}

