/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;

public class NewMergeFileAssociationWizardPage
extends WizardPage {
    private MergeFileAssociation[] mergeFileAssociations;
    protected Text fileTypeText;
    private Text defaultProgramLocationText;
    private Text defaultProgramParametersText;
    protected Combo customProgramLocationCombo;
    protected Text customProgramParametersText;
    protected Button builtInMergeRadioButton;
    protected Button externalMergeRadioButton;
    protected Button customMergeRadioButton;
    private Button browseMergeProgramButton;
    private Button variablesButton;

    public NewMergeFileAssociationWizardPage(String pageName, String title, ImageDescriptor titleImage, MergeFileAssociation[] mergeFileAssociations) {
        super(pageName, title, titleImage);
        this.mergeFileAssociations = mergeFileAssociations;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Label fileTypeLabel = new Label(composite, 0);
        fileTypeLabel.setText(Policy.bind("NewMergeFileAssociationWizardPage.fileType"));
        this.fileTypeText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.widthHint = 300;
        this.fileTypeText.setLayoutData((Object)gridData);
        Group mergeProgramGroup = new Group(composite, 0);
        mergeProgramGroup.setText(Policy.bind("MergeFileAssociationPreferencePage.mergeProgramGroup"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        mergeProgramGroup.setLayoutData((Object)gridData);
        GridLayout mergeProgramGroupLayout = new GridLayout();
        mergeProgramGroupLayout.numColumns = 3;
        mergeProgramGroup.setLayout((Layout)mergeProgramGroupLayout);
        this.builtInMergeRadioButton = new Button((Composite)mergeProgramGroup, 16);
        this.builtInMergeRadioButton.setText(Policy.bind("DiffMergePreferencePage.builtInMerge"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.builtInMergeRadioButton.setLayoutData((Object)gridData);
        this.externalMergeRadioButton = new Button((Composite)mergeProgramGroup, 16);
        this.externalMergeRadioButton.setText(Policy.bind("MergeFileAssociationPreferencePage.defaultExternal"));
        gridData = new GridData();
        this.defaultProgramLocationText = new Text((Composite)mergeProgramGroup, 2048);
        this.defaultProgramLocationText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 400;
        this.defaultProgramLocationText.setLayoutData((Object)gridData);
        Label defaultParametersLabel = new Label((Composite)mergeProgramGroup, 0);
        defaultParametersLabel.setText(Policy.bind("DiffMergePreferencePage.mergeProgramParameters"));
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        defaultParametersLabel.setLayoutData((Object)gridData);
        this.defaultProgramParametersText = new Text((Composite)mergeProgramGroup, 2048);
        this.defaultProgramParametersText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 400;
        this.defaultProgramParametersText.setLayoutData((Object)gridData);
        this.defaultProgramLocationText.setText(store.getString("pref_merge_program_location"));
        this.defaultProgramParametersText.setText(store.getString("pref_merge_program_parameters"));
        this.customMergeRadioButton = new Button((Composite)mergeProgramGroup, 16);
        this.customMergeRadioButton.setText(Policy.bind("MergeFileAssociationPreferencePage.customExternal"));
        this.customProgramLocationCombo = new Combo((Composite)mergeProgramGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 400;
        this.customProgramLocationCombo.setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.mergeFileAssociations.length) {
            if (this.mergeFileAssociations[i].getType() == 2 && this.customProgramLocationCombo.indexOf(this.mergeFileAssociations[i].getMergeProgram()) == -1) {
                this.customProgramLocationCombo.add(this.mergeFileAssociations[i].getMergeProgram());
            }
            ++i;
        }
        this.browseMergeProgramButton = new Button((Composite)mergeProgramGroup, 8);
        this.browseMergeProgramButton.setText(Policy.bind("DiffMergePreferencePage.browse"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.browseMergeProgramButton.setLayoutData((Object)gridData);
        this.browseMergeProgramButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(NewMergeFileAssociationWizardPage.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    NewMergeFileAssociationWizardPage.this.customProgramLocationCombo.setText(res);
                }
            }
        });
        Label customParametersLabel = new Label((Composite)mergeProgramGroup, 0);
        customParametersLabel.setText(Policy.bind("NewMergeFileAssociationWizardPage.customParameters"));
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        customParametersLabel.setLayoutData((Object)gridData);
        this.customProgramParametersText = new Text((Composite)mergeProgramGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 400;
        this.customProgramParametersText.setLayoutData((Object)gridData);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fileTypeText.addFocusListener((FocusListener)focusListener);
        this.customProgramParametersText.addFocusListener((FocusListener)focusListener);
        this.variablesButton = new Button((Composite)mergeProgramGroup, 8);
        this.variablesButton.setText(Policy.bind("DiffMergePreferencePage.mergeProgramVariables"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.variablesButton.setLayoutData((Object)gridData);
        final Text formatToInsert = this.customProgramParametersText;
        this.variablesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewMergeFileAssociationWizardPage.this.addVariables(formatToInsert, NewMergeFileAssociationWizardPage.this.getMergeBindingDescriptions());
            }
        });
        this.customMergeRadioButton.setSelection(true);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMergeFileAssociationWizardPage.this.setPageComplete(NewMergeFileAssociationWizardPage.this.canFinish());
            }
        };
        this.fileTypeText.addModifyListener(modifyListener);
        this.customProgramLocationCombo.addModifyListener(modifyListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMergeFileAssociationWizardPage.this.setPageComplete(NewMergeFileAssociationWizardPage.this.canFinish());
                NewMergeFileAssociationWizardPage.this.customProgramLocationCombo.setEnabled(NewMergeFileAssociationWizardPage.this.customMergeRadioButton.getSelection());
                NewMergeFileAssociationWizardPage.this.customProgramParametersText.setEnabled(NewMergeFileAssociationWizardPage.this.customMergeRadioButton.getSelection());
                if (e.getSource() == NewMergeFileAssociationWizardPage.this.customMergeRadioButton && NewMergeFileAssociationWizardPage.this.customMergeRadioButton.getSelection()) {
                    NewMergeFileAssociationWizardPage.this.customProgramLocationCombo.setFocus();
                }
                if (e.getSource() == NewMergeFileAssociationWizardPage.this.customProgramLocationCombo) {
                    int i = 0;
                    while (i < NewMergeFileAssociationWizardPage.this.mergeFileAssociations.length) {
                        if (NewMergeFileAssociationWizardPage.this.mergeFileAssociations[i].getType() == 2 && NewMergeFileAssociationWizardPage.this.mergeFileAssociations[i].getMergeProgram().equals(NewMergeFileAssociationWizardPage.this.customProgramLocationCombo.getText())) {
                            NewMergeFileAssociationWizardPage.this.customProgramParametersText.setText(NewMergeFileAssociationWizardPage.this.mergeFileAssociations[i].getParameters());
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
        this.builtInMergeRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.externalMergeRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.customMergeRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.customProgramLocationCombo.addSelectionListener((SelectionListener)selectionListener);
        this.fileTypeText.setFocus();
        this.setControl((Control)composite);
    }

    private boolean canFinish() {
        this.setErrorMessage(null);
        if (this.fileTypeText.getText().trim().length() == 0) {
            return false;
        }
        if (this.fileTypeText.getText().indexOf(".") == -1) {
            return false;
        }
        int i = 0;
        while (i < this.mergeFileAssociations.length) {
            if (this.mergeFileAssociations[i].getFileType().equals(this.fileTypeText.getText().trim())) {
                Object[] fileType = new String[]{this.fileTypeText.getText().trim()};
                this.setErrorMessage(Policy.bind("NewMergeFileAssociationWizardPage.fileTypeExists", fileType));
                return false;
            }
            ++i;
        }
        return !this.customMergeRadioButton.getSelection() || this.customProgramLocationCombo.getText().trim().length() != 0;
    }

    private void addVariables(Text target, Map bindings) {
        final ArrayList<StringPair> variables = new ArrayList<StringPair>(bindings.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((StringPair)element).s1) + " - " + ((StringPair)element).s2;
            }
        };
        IStructuredContentProvider contentsProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return variables.toArray(new StringPair[variables.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        Iterator it = bindings.keySet().iterator();
        while (it.hasNext()) {
            StringPair variable = new StringPair();
            variable.s1 = (String)it.next();
            variable.s2 = (String)bindings.get(variable.s1);
            variables.add(variable);
        }
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider(contentsProvider);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setInput(variables);
        dialog.setTitle(Policy.bind("DiffMergePreferencePage.addVariableDialogTitle"));
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        int i = 0;
        while (i < result.length) {
            target.insert("${" + ((StringPair)result[i]).s1 + "}");
            ++i;
        }
    }

    private Map getMergeBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("merged", Policy.bind("DiffMergePreferencePage.mergedVariableComment"));
        bindings.put("theirs", Policy.bind("DiffMergePreferencePage.theirsVariableComment"));
        bindings.put("yours", Policy.bind("DiffMergePreferencePage.yoursVariableComment"));
        bindings.put("base", Policy.bind("DiffMergePreferencePage.baseVariableComment"));
        return bindings;
    }

    class StringPair {
        String s1;
        String s2;

        StringPair() {
        }
    }
}

