/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.RevisionAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperationWC;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNLocalBranchTagCompareInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private ISVNLocalResource[] resources;
    private SVNUrl[] urls;
    private SVNRevision remoteRevision;
    private IWorkbenchPart targetPart;
    private Exception getDiffException;
    private SVNLocalResourceNode[] localResourceNodes;
    private ResourceEditionNode[] remoteResourceNodes;

    public SVNLocalBranchTagCompareInput(ISVNLocalResource[] resources, SVNUrl[] urls, SVNRevision remoteRevision, IWorkbenchPart targetPart) throws SVNException {
        super(new CompareConfiguration());
        this.resources = resources;
        this.urls = urls;
        this.remoteRevision = remoteRevision;
        this.targetPart = targetPart;
        this.localResourceNodes = new SVNLocalResourceNode[resources.length];
        this.remoteResourceNodes = new ResourceEditionNode[resources.length];
        int i = 0;
        while (i < resources.length) {
            this.localResourceNodes[i] = new SVNLocalResourceNode(resources[i]);
            Object remoteResource = resources[i] instanceof ISVNLocalFolder ? new RemoteFolder(resources[i].getRepository(), urls[i], remoteRevision) : new RemoteFile(resources[i].getRepository(), urls[i], remoteRevision);
            this.remoteResourceNodes[i] = new ResourceEditionNode((ISVNRemoteResource)remoteResource);
            this.remoteResourceNodes[i].setLocalResource(this.localResourceNodes[i]);
            this.localResourceNodes[i].setRemoteResource(this.remoteResourceNodes[i]);
            ++i;
        }
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        this.setTitle("Compare <workspace> and versions");
        cc.setLeftEditable(true);
        cc.setRightEditable(false);
        String leftLabel = "<workspace>";
        cc.setLeftLabel(leftLabel);
        String rightLabel = "Repository";
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DiffNode diffNode;
        this.initLabels();
        File[] diffFiles = new File[this.localResourceNodes.length];
        try {
            int i = 0;
            while (i < this.localResourceNodes.length) {
                File file = File.createTempFile("revision", ".diff");
                file.deleteOnExit();
                final ShowDifferencesAsUnifiedDiffOperationWC operation = new ShowDifferencesAsUnifiedDiffOperationWC(this.targetPart, this.localResourceNodes[i].getLocalResource().getFile(), this.remoteResourceNodes[i].getRemoteResource().getUrl(), this.remoteRevision, file);
                operation.setGraphicalCompare(true);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            operation.run();
                        }
                        catch (Exception exception) {}
                    }
                });
                diffFiles[i] = operation.getFile();
                ++i;
            }
        }
        catch (Exception exception) {}
        MultipleSelectionNode left = new MultipleSelectionNode((Object[])this.localResourceNodes);
        MultipleSelectionNode right = new MultipleSelectionNode(this.remoteResourceNodes);
        Object differences = new RevisionAwareDifferencer(diffFiles).findDifferences(false, monitor, null, null, left, right);
        if (differences instanceof DiffNode && !(diffNode = (DiffNode)differences).hasChildren()) {
            return null;
        }
        return differences;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }
}

