/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.service.prefs.BackingStoreException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.conflicts.ConflictsCompareInput;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;
import org.tigris.subversion.svnclientadapter.utils.Command;

public class EditConflictsAction
extends WorkbenchWindowAction {
    private IFile selectedResource;
    private Exception exception;

    public EditConflictsAction() {
    }

    public EditConflictsAction(IFile selectedResource) {
        this();
        this.selectedResource = selectedResource;
    }

    private void editConflictsInternal(IFile resource, IFile conflictOldFile, IFile conflictWorkingFile, IFile conflictNewFile) throws InvocationTargetException, InterruptedException {
        CompareConfiguration cc = new CompareConfiguration();
        ConflictsCompareInput fInput = new ConflictsCompareInput(cc);
        fInput.setResources(conflictOldFile, conflictWorkingFile, conflictNewFile, resource);
        CompareUI.openCompareEditorOnPage((CompareEditorInput)fInput, (IWorkbenchPage)this.getTargetPage());
    }

    private void editConflictsExternal(IFile resource, IFile conflictOldFile, IFile conflictWorkingFile, IFile conflictNewFile, String mergeProgramLocation, String mergeProgramParameters) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            if (mergeProgramLocation.equals("")) {
                throw new SVNException(Policy.bind("EditConflictsAction.noMergeProgramConfigured"));
            }
            File mergeProgramFile = new File(mergeProgramLocation);
            if (!mergeProgramFile.exists()) {
                throw new SVNException(Policy.bind("EditConflictsAction.mergeProgramDoesNotExist"));
            }
            Command command = new Command(mergeProgramLocation);
            String[] parameters = mergeProgramParameters.split(" ");
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = this.replaceParameter(parameters[i], "${theirs}", conflictNewFile.getLocation().toFile().getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${yours}", conflictWorkingFile.getLocation().toFile().getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${base}", conflictOldFile.getLocation().toFile().getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${merged}", resource.getLocation().toFile().getAbsolutePath());
                ++i;
            }
            command.setParameters(parameters);
            command.exec();
            command.waitFor();
            resource.refreshLocal(0, null);
        }
        catch (IOException e) {
            throw new SVNException(String.valueOf(Policy.bind("EditConflictsAction.1")) + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IFile resource = this.selectedResource == null ? (IFile)this.getSelectedResources()[0] : this.selectedResource;
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            IFile conflictNewFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictNew());
            IFile conflictOldFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictOld());
            IFile conflictWorkingFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictWorking());
            if (conflictWorkingFile == null) {
                conflictWorkingFile = resource;
            }
            MergeFileAssociation mergeFileAssociation = null;
            try {
                mergeFileAssociation = SVNUIPlugin.getPlugin().getMergeFileAssociation(resource.getName());
            }
            catch (BackingStoreException backingStoreException) {
                mergeFileAssociation = new MergeFileAssociation();
            }
            if (mergeFileAssociation.getType() == 0) {
                this.editConflictsInternal(resource, conflictOldFile, conflictWorkingFile, conflictNewFile);
            } else if (mergeFileAssociation.getType() == 1) {
                IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
                String mergeProgramLocation = preferenceStore.getString("pref_merge_program_location");
                String mergeProgramParameters = preferenceStore.getString("pref_merge_program_parameters");
                this.editConflictsExternal(resource, conflictOldFile, conflictWorkingFile, conflictNewFile, mergeProgramLocation, mergeProgramParameters);
            } else {
                this.editConflictsExternal(resource, conflictOldFile, conflictWorkingFile, conflictNewFile, mergeFileAssociation.getMergeProgram(), mergeFileAssociation.getParameters());
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
        if (this.exception != null) {
            throw new InvocationTargetException(this.exception);
        }
    }

    @Override
    protected String getErrorTitle() {
        return Policy.bind("EditConflictsAction.errorTitle");
    }

    @Override
    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) {
        block3: {
            try {
                if (super.isEnabledForSVNResource(svnResource)) break block3;
                return false;
            }
            catch (SVNException sVNException) {
                return false;
            }
        }
        return svnResource.getStatusFromCache().isTextConflicted();
    }

    @Override
    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    private String replaceParameter(String input, String pattern, String value) {
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = input.indexOf(pattern, startIdx)) >= 0) {
            result.append(input.substring(startIdx, idxOld));
            result.append(value);
            startIdx = idxOld + pattern.length();
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }

    @Override
    protected String getImageId() {
        return "Menu Edit Conflicts";
    }
}

