/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.launch.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.jboss.tools.cordovasim.eclipse.Activator;
import org.jboss.tools.cordovasim.eclipse.launch.CordovaSimLaunchParametersUtil;
import org.jboss.tools.cordovasim.eclipse.launch.internal.CordovaSimLaunchConfigurationAutofillUtil;
import org.jboss.tools.cordovasim.eclipse.launch.internal.Messages;

public class CordovaSimLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Image image = Activator.getImageDescriptor("icons/cordovasim_16.png").createImage();
    private WidgetListener defaultListener = new WidgetListener();
    private Text projectText;
    private Button useDefaultRootFolderCheckbox;
    private Text rootFolderText;
    private Button rootFolderButton;
    private Button useDefaultStartPageCheckbox;
    private Text startPageText;
    private Button startPageButton;
    private Button useDefaultPortCheckbox;
    private Text portText;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createRootFolderEditor(comp);
        this.createStartPageEditor(comp);
        this.createServerEditor(comp);
        this.setControl((Control)comp);
    }

    private void createProjectEditor(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.CordovaSimLaunchConfigurationTab_PROJECT, (int)2, (int)1, (int)768);
        this.projectText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.projectText.addModifyListener((ModifyListener)this.defaultListener);
        Button peojectButton = this.createPushButton((Composite)group, Messages.CordovaSimLaunchConfigurationTab_BROWSE, null);
        peojectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CordovaSimLaunchConfigurationTab.this.handleProjectButtonSelected();
            }
        });
    }

    private void createRootFolderEditor(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.CordovaSimLaunchConfigurationTab_ROOT_FOLDER, (int)2, (int)1, (int)768);
        this.useDefaultRootFolderCheckbox = SWTFactory.createCheckButton((Composite)group, (String)Messages.CordovaSimLaunchConfigurationTab_USE_DEFAULT, null, (boolean)true, (int)2);
        this.rootFolderText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.rootFolderText.addModifyListener((ModifyListener)this.defaultListener);
        this.rootFolderButton = this.createPushButton((Composite)group, Messages.CordovaSimLaunchConfigurationTab_BROWSE, null);
        this.rootFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CordovaSimLaunchConfigurationTab.this.handleRootFolderButtonSelected();
            }
        });
        this.useDefaultRootFolderCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaultRootFolder = ((Button)e.widget).getSelection();
                CordovaSimLaunchConfigurationTab.this.rootFolderText.setEnabled(!useDefaultRootFolder);
                CordovaSimLaunchConfigurationTab.this.rootFolderButton.setEnabled(!useDefaultRootFolder);
                IProject project = CordovaSimLaunchConfigurationTab.this.getSelectedProject();
                if (useDefaultRootFolder) {
                    CordovaSimLaunchConfigurationTab.this.setSelectedRootFolder(project, null);
                } else {
                    CordovaSimLaunchConfigurationTab.this.rootFolderText.setEnabled(true);
                    CordovaSimLaunchConfigurationTab.this.rootFolderButton.setEnabled(true);
                }
                CordovaSimLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createStartPageEditor(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.CordovaSimLaunchConfigurationTab_START_PAGE, (int)2, (int)1, (int)768);
        this.useDefaultStartPageCheckbox = SWTFactory.createCheckButton((Composite)group, (String)Messages.CordovaSimLaunchConfigurationTab_USE_DEFAULT, null, (boolean)true, (int)2);
        this.startPageText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.startPageText.addModifyListener((ModifyListener)this.defaultListener);
        this.startPageButton = this.createPushButton((Composite)group, Messages.CordovaSimLaunchConfigurationTab_BROWSE, null);
        this.startPageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CordovaSimLaunchConfigurationTab.this.handleStartPageButtonSelected();
            }
        });
        this.useDefaultStartPageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaultStartPage = ((Button)e.widget).getSelection();
                IProject project = CordovaSimLaunchConfigurationTab.this.getSelectedProject();
                IContainer rootFolder = CordovaSimLaunchConfigurationTab.this.getActualRootFolder(project);
                if (useDefaultStartPage) {
                    CordovaSimLaunchConfigurationTab.this.setSelectedStartPage(project, rootFolder, null, null);
                } else {
                    CordovaSimLaunchConfigurationTab.this.startPageText.setEnabled(true);
                    CordovaSimLaunchConfigurationTab.this.startPageButton.setEnabled(true);
                }
                CordovaSimLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createServerEditor(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.CordovaSimLaunchConfigurationTab_SERVER_PORT, (int)2, (int)1, (int)768);
        this.useDefaultPortCheckbox = SWTFactory.createCheckButton((Composite)group, (String)Messages.CordovaSimLaunchConfigurationTab_USE_DEFAULT, null, (boolean)true, (int)2);
        SWTFactory.createLabel((Composite)group, (String)Messages.CordovaSimLaunchConfigurationTab_PORT, (int)1);
        this.portText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.portText.addModifyListener((ModifyListener)this.defaultListener);
        this.useDefaultPortCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaultPort = ((Button)e.widget).getSelection();
                CordovaSimLaunchConfigurationTab.this.setSelectedPort(useDefaultPort ? null : Integer.valueOf(4400));
            }
        });
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.getSelectedProject();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        dialog.setTitle(Messages.CordovaSimLaunchConfigurationTab_PROJECT_SELECTION);
        dialog.setMessage(Messages.CordovaSimLaunchConfigurationTab_SELECT_PROJECT);
        ArrayList<IProject> openPojects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.isOpen()) {
                openPojects.add(p);
            }
            ++n2;
        }
        dialog.setElements((Object[])openPojects.toArray(new IProject[0]));
        if (project != null) {
            dialog.setInitialSelections((Object[])new IProject[]{project});
        }
        dialog.setDialogBoundsSettings(this.getDialogBoundsSettings("org.jboss.tools.cordovasim.eclipse.PROJECT_DIALOG"), 2);
        dialog.open();
        IProject newProject = (IProject)dialog.getFirstResult();
        if (newProject != null) {
            this.setSelectedProject(newProject);
        }
    }

    protected void handleRootFolderButtonSelected() {
        final IProject project = this.getSelectedProject();
        IContainer rootFolder = this.getActualRootFolder(project);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.CordovaSimLaunchConfigurationTab_ROOT_FOLDER_SELECTION);
        dialog.setMessage(Messages.CordovaSimLaunchConfigurationTab_CHOOSE_ROOT_FOLDER);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setDialogBoundsSettings(this.getDialogBoundsSettings("org.jboss.tools.cordovasim.eclipse.ROOT_FOLDER_LOCATION_DIALOG"), 2);
        dialog.setInitialSelection((Object)rootFolder);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element == project) {
                    return true;
                }
                return element instanceof IFolder && CordovaSimLaunchParametersUtil.getRelativePath((IContainer)project, (IResource)((IFolder)element)) != null;
            }
        });
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result instanceof IContainer) {
            IContainer newRootContainer = (IContainer)result;
            this.setSelectedRootFolder(project, newRootContainer);
            String containerName = CordovaSimLaunchParametersUtil.getRelativePath((IContainer)project, (IResource)newRootContainer).toString();
            this.rootFolderText.setText(containerName);
        }
    }

    protected void handleStartPageButtonSelected() {
        IProject project = this.getSelectedProject();
        IContainer rootFolder = this.getActualRootFolder(project);
        IResource startPage = this.getActualStartPage(project, rootFolder);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.CordovaSimLaunchConfigurationTab_START_PAGE_SELECTION);
        dialog.setMessage(Messages.CordovaSimLaunchConfigurationTab_CHOOSE_START_PAGE_FILE);
        dialog.setInput((Object)rootFolder);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setDialogBoundsSettings(this.getDialogBoundsSettings("org.jboss.tools.cordovasim.eclipse.ROOT_START_PAGE_LOCATION_DIALOG"), 2);
        dialog.setInitialSelection((Object)startPage);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    String extension = ((IFile)element).getFileExtension();
                    return "html".equals(extension) || "htm".equals(extension);
                }
                return true;
            }
        });
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result instanceof IFile) {
            IFile newStartPageFile = (IFile)result;
            this.setSelectedStartPage(project, rootFolder, (IResource)newStartPageFile, null);
        }
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null) {
            ISelection selection = activePage.getSelection();
            IProject project = CordovaSimLaunchConfigurationAutofillUtil.getProjectToRun(selection);
            CordovaSimLaunchConfigurationAutofillUtil.fillLaunchConfiguraion(configuration, project);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IProject project = null;
        try {
            String projectString = configuration.getAttribute(".PROJECT", null);
            project = CordovaSimLaunchParametersUtil.getProject(projectString);
        }
        catch (CoreException projectString) {
            // empty catch block
        }
        this.setSelectedProject(project);
        IContainer rootFolder = null;
        try {
            String rootFolderString = configuration.getAttribute("org.jboss.tools.cordovasim.eclipse.ROOT_FOLDER", null);
            rootFolder = CordovaSimLaunchParametersUtil.getRootFolder(project, rootFolderString);
        }
        catch (CoreException rootFolderString) {
            // empty catch block
        }
        this.setSelectedRootFolder(project, rootFolder);
        rootFolder = this.getActualRootFolder(project);
        IResource startPage = null;
        String startPageString = null;
        try {
            startPageString = configuration.getAttribute("org.jboss.tools.cordovasim.eclipse.START_PAGE", null);
            startPage = CordovaSimLaunchParametersUtil.getStartPage(rootFolder, startPageString);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.setSelectedStartPage(project, rootFolder, startPage, startPageString);
        Integer port = null;
        try {
            if (configuration.hasAttribute("org.jboss.tools.cordovasim.eclipse.PORT")) {
                port = configuration.getAttribute("org.jboss.tools.cordovasim.eclipse.PORT", 0);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.setSelectedPort(port);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setMappedResources(new IResource[]{this.getSelectedProject()});
        configuration.setAttribute(".PROJECT", this.projectText.getText());
        String rootFolderString = null;
        if (!this.useDefaultRootFolderCheckbox.getSelection()) {
            rootFolderString = this.rootFolderText.getText();
        }
        configuration.setAttribute("org.jboss.tools.cordovasim.eclipse.ROOT_FOLDER", rootFolderString);
        String startPageString = null;
        if (!this.useDefaultStartPageCheckbox.getSelection()) {
            startPageString = this.startPageText.getText();
        }
        configuration.setAttribute("org.jboss.tools.cordovasim.eclipse.START_PAGE", startPageString);
        Integer port = this.getSelectedPort();
        if (port == null) {
            configuration.removeAttribute("org.jboss.tools.cordovasim.eclipse.PORT");
        } else {
            configuration.setAttribute("org.jboss.tools.cordovasim.eclipse.PORT", port.intValue());
        }
    }

    public String getName() {
        return Messages.CordovaSimLaunchConfigurationTab_MAIN;
    }

    public Image getImage() {
        return this.image;
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IResource startPage;
        IContainer rootFolder;
        IProject project;
        this.setErrorMessage(null);
        String projectString = this.projectText.getText();
        try {
            project = CordovaSimLaunchParametersUtil.validateAndGetProject(projectString);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        if (!this.useDefaultRootFolderCheckbox.getSelection()) {
            String rootFolderString = this.rootFolderText.getText();
            try {
                rootFolder = CordovaSimLaunchParametersUtil.validateAndGetRootFolder(project, rootFolderString);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                return false;
            }
        } else {
            rootFolder = CordovaSimLaunchParametersUtil.getDefaultRootFolder(project);
            if (rootFolder == null) {
                this.setErrorMessage(Messages.CordovaSimLaunchConfigurationTab_NO_ROOT_FOLDER);
                return false;
            }
        }
        if (!this.useDefaultStartPageCheckbox.getSelection()) {
            String startPageString = this.startPageText.getText();
            try {
                startPage = CordovaSimLaunchParametersUtil.validateAndGetStartPage(rootFolder, startPageString);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                return false;
            }
        } else {
            startPage = CordovaSimLaunchParametersUtil.getDefaultStartPage(project, rootFolder);
            if (startPage == null) {
                this.setErrorMessage(Messages.CordovaSimLaunchConfigurationTab_NO_START_PAGE);
                return false;
            }
        }
        if (!this.useDefaultPortCheckbox.getSelection()) {
            String portString = this.portText.getText();
            try {
                CordovaSimLaunchParametersUtil.validatePortNumber(portString);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                return false;
            }
        }
        return true;
    }

    private IProject getSelectedProject() {
        String projectString = this.projectText.getText();
        return CordovaSimLaunchParametersUtil.getProject(projectString);
    }

    private void setSelectedProject(IProject project) {
        this.projectText.setText(project != null ? project.getName() : "");
        IContainer rootFolder = this.getSelectedRootFolder(project);
        if (rootFolder == null) {
            this.setSelectedRootFolder(project, null);
            rootFolder = CordovaSimLaunchParametersUtil.getDefaultRootFolder(project);
        }
        if (this.getSelectedStartPage(project, rootFolder) == null) {
            this.setSelectedStartPage(project, rootFolder, null, null);
        }
    }

    private IContainer getSelectedRootFolder(IProject project) {
        if (!this.useDefaultRootFolderCheckbox.getSelection()) {
            String rootFolderString = this.rootFolderText.getText();
            return CordovaSimLaunchParametersUtil.getRootFolder(project, rootFolderString);
        }
        return null;
    }

    private void setSelectedRootFolder(IProject project, IContainer rootFolder) {
        boolean useDefaultRootFolder = rootFolder == null;
        this.useDefaultRootFolderCheckbox.setSelection(useDefaultRootFolder);
        this.rootFolderText.setEnabled(!useDefaultRootFolder);
        this.rootFolderButton.setEnabled(!useDefaultRootFolder);
        IContainer actualRootFolder = useDefaultRootFolder ? CordovaSimLaunchParametersUtil.getDefaultRootFolder(project) : rootFolder;
        IPath rootFolderRelative = CordovaSimLaunchParametersUtil.getRelativePath((IContainer)project, (IResource)actualRootFolder);
        this.rootFolderText.setText(rootFolderRelative != null ? rootFolderRelative.toString() : "");
    }

    private IResource getSelectedStartPage(IProject project, IContainer rootFolder) {
        if (this.useDefaultStartPageCheckbox.getSelection()) {
            return null;
        }
        String startPageString = this.startPageText.getText();
        return CordovaSimLaunchParametersUtil.getStartPage(rootFolder, startPageString);
    }

    private void setSelectedStartPage(IProject project, IContainer rootFolder, IResource startPage, String startPageString) {
        boolean useDefaultStartPage = startPage == null;
        this.useDefaultStartPageCheckbox.setSelection(useDefaultStartPage);
        this.startPageText.setEnabled(!useDefaultStartPage);
        this.startPageButton.setEnabled(!useDefaultStartPage);
        IResource actualStartPage = useDefaultStartPage ? CordovaSimLaunchParametersUtil.getDefaultStartPage(project, rootFolder) : startPage;
        IPath startPagePath = CordovaSimLaunchParametersUtil.getRelativePath(rootFolder, actualStartPage);
        String queryParameters = null;
        if (startPageString != null) {
            queryParameters = CordovaSimLaunchParametersUtil.getStartPageParameters(startPageString);
        } else {
            String startPageFromConfigXml = CordovaSimLaunchParametersUtil.getDefaultStartPageFromConfigXml(project);
            queryParameters = CordovaSimLaunchParametersUtil.getStartPageParameters(startPageFromConfigXml);
        }
        queryParameters = queryParameters == null ? "" : queryParameters;
        this.startPageText.setText(startPagePath != null ? String.valueOf(startPagePath.toString()) + queryParameters : "");
    }

    private IResource getActualStartPage(IProject project, IContainer rootFolder) {
        IResource startPage = this.getSelectedStartPage(project, rootFolder);
        if (startPage == null) {
            startPage = CordovaSimLaunchParametersUtil.getDefaultStartPage(project, rootFolder);
        }
        return startPage;
    }

    private IContainer getActualRootFolder(IProject project) {
        IContainer rootFolder = this.getSelectedRootFolder(project);
        if (rootFolder == null) {
            rootFolder = CordovaSimLaunchParametersUtil.getDefaultRootFolder(project);
        }
        return rootFolder;
    }

    private Integer getSelectedPort() {
        if (this.useDefaultPortCheckbox.getSelection()) {
            return null;
        }
        int port = 0;
        try {
            port = Integer.parseInt(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    private void setSelectedPort(Integer port) {
        boolean useDefaultPort = port == null;
        this.useDefaultPortCheckbox.setSelection(useDefaultPort);
        this.portText.setEnabled(!useDefaultPort);
        this.portText.setText(port != null ? port.toString() : "");
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            CordovaSimLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CordovaSimLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }
}

