/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.jboss.tools.cordovasim.eclipse.Activator;
import org.jboss.tools.cordovasim.eclipse.launch.internal.Messages;

public class CordovaSimLaunchParametersUtil {
    private static final String AEROGEAR_HYBRID_NATURE_ID = "org.eclipse.thym.core.HybridAppNature";
    private static final String ANDROID_NATURE_ID = "com.android.ide.eclipse.adt.AndroidNature";
    private static final String ANDROID_PLATFORM_ID = "android";

    public static IProject validateAndGetProject(String projectString) throws CoreException {
        IProject project = CordovaSimLaunchParametersUtil.getProject(projectString);
        if (project == null || !project.isOpen()) {
            throw new CoreException(CordovaSimLaunchParametersUtil.createErrorStatus(Messages.CordovaSimLaunchParametersUtil_INVALID_START_PAGE_PATH));
        }
        return project;
    }

    public static IProject getProject(String projectString) {
        if (projectString != null) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectString);
                if (project != null && project.exists()) {
                    return project;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static IContainer getRootFolder(IProject project, String rootFolderString) {
        IResource resource;
        if (project != null && rootFolderString != null && rootFolderString.length() > 0 && (resource = project.findMember((IPath)new Path(rootFolderString))) instanceof IContainer) {
            return (IContainer)resource;
        }
        return null;
    }

    public static IResource getStartPage(IContainer container, String path) {
        if (container != null && path != null && path.length() > 0) {
            int queryIndex = path.indexOf("?");
            if (queryIndex > 0) {
                path = path.substring(0, queryIndex);
            }
            return container.findMember((IPath)new Path(path));
        }
        return null;
    }

    public static IContainer validateAndGetRootFolder(IProject project, String rootFolderString) throws CoreException {
        IContainer rootFolder = CordovaSimLaunchParametersUtil.getRootFolder(project, rootFolderString);
        if (rootFolder == null || !rootFolder.exists()) {
            throw new CoreException(CordovaSimLaunchParametersUtil.createErrorStatus(Messages.CordovaSimLaunchParametersUtil_INVALID_ROOT_FOLDER_PATH));
        }
        return rootFolder;
    }

    public static IResource validateAndGetStartPage(IContainer rootFolder, String startPageString) throws CoreException {
        IResource startPage;
        int indexOfQueryParameter = startPageString.indexOf("?");
        if (indexOfQueryParameter > 0) {
            startPageString = startPageString.substring(0, indexOfQueryParameter);
        }
        if ((startPage = CordovaSimLaunchParametersUtil.getStartPage(rootFolder, startPageString)) == null || !startPage.exists()) {
            throw new CoreException(CordovaSimLaunchParametersUtil.createErrorStatus(Messages.CordovaSimLaunchParametersUtil_INVALID_START_PAGE_PATH));
        }
        return startPage;
    }

    public static void validatePortNumber(String portString) throws CoreException {
        try {
            int port = Integer.parseInt(portString);
            if (port < 1 || 65535 < port) {
                throw new CoreException(CordovaSimLaunchParametersUtil.createErrorStatus(Messages.CordovaSimLaunchParametersUtil_INVALID_PORT));
            }
        }
        catch (NumberFormatException e) {
            throw new CoreException(CordovaSimLaunchParametersUtil.createErrorStatus(Messages.CordovaSimLaunchParametersUtil_INVALID_PORT));
        }
    }

    private static IStatus createErrorStatus(String message) {
        return new Status(4, "org.jboss.tools.cordovasim.eclipse", message);
    }

    public static IContainer getDefaultRootFolder(IProject project) {
        Object rootFolder = null;
        if (project != null && project.isOpen()) {
            try {
                rootFolder = project.hasNature(AEROGEAR_HYBRID_NATURE_ID) ? CordovaSimLaunchParametersUtil.getRootFolder(project, "www") : (project.hasNature(ANDROID_NATURE_ID) ? CordovaSimLaunchParametersUtil.getRootFolder(project, "assets/www") : project);
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return rootFolder;
    }

    public static IResource getDefaultStartPage(IProject project, IContainer rootFolder) {
        String startPageName = CordovaSimLaunchParametersUtil.getDefaultStartPageFromConfigXml(project);
        IResource startPage = CordovaSimLaunchParametersUtil.getStartPage(rootFolder, startPageName);
        return startPage;
    }

    public static String getDefaultStartPageFromConfigXml(IProject project) {
        IFile configFile = CordovaSimLaunchParametersUtil.getConfigXml(project);
        String startPageName = CordovaSimLaunchParametersUtil.getStartPageName(configFile);
        if (startPageName == null) {
            startPageName = "index.html";
        }
        return startPageName;
    }

    public static IFile getConfigXml(IProject project) {
        IFile configFile = null;
        if (project != null && project.isOpen()) {
            try {
                if (project.hasNature(AEROGEAR_HYBRID_NATURE_ID)) {
                    configFile = CordovaSimLaunchParametersUtil.getConfigXmlForThymProject(project);
                } else if (project.hasNature(ANDROID_NATURE_ID)) {
                    configFile = CordovaSimLaunchParametersUtil.getConfigXmlForAndroidProject(project);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return configFile;
    }

    private static IFile getConfigXmlForThymProject(IProject project) {
        return HybridProject.getHybridProject((IProject)project).getConfigFile();
    }

    private static IFile getConfigXmlForAndroidProject(IProject project) {
        IResource configResource = project.findMember("res/xml/config.xml");
        if (configResource instanceof IFile) {
            return (IFile)configResource;
        }
        return null;
    }

    public static String getCordovaEngineLocation(IProject project) {
        HybridMobileLibraryResolver platformLibraryResolver;
        HybridMobileEngine platformEngine;
        HybridMobileEngine[] activeEngines;
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)project);
        if (hybridProject != null && (activeEngines = hybridProject.getEngineManager().getEngines()) != null && activeEngines.length > 0 && (platformEngine = CordovaSimLaunchParametersUtil.getPlatformEngine(activeEngines)) != null && (platformLibraryResolver = platformEngine.getResolver()) != null) {
            String templateCordovaJS = platformLibraryResolver.getTemplateFile("cordova.js");
            return project.getProject().getFile(new Path("platforms/").append(templateCordovaJS)).getRawLocation().toOSString();
        }
        return null;
    }

    public static String getCordovaVersion(IProject project) {
        HybridMobileEngine[] activeEngines;
        HybridMobileEngine activeEngine;
        HybridProject hybridProject = HybridProject.getHybridProject((IProject)project);
        if (hybridProject != null && (activeEngine = CordovaSimLaunchParametersUtil.getPlatformEngine(activeEngines = hybridProject.getEngineManager().getEngines())) != null) {
            return activeEngine.getSpec();
        }
        return null;
    }

    private static HybridMobileEngine getPlatformEngine(HybridMobileEngine[] engines) {
        if (engines == null || engines.length < 1) {
            return null;
        }
        HybridMobileEngine[] hybridMobileEngineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            HybridMobileEngine hybridMobileEngine = hybridMobileEngineArray[n2];
            if (hybridMobileEngine.getName().equals(ANDROID_PLATFORM_ID)) {
                return hybridMobileEngine;
            }
            ++n2;
        }
        return engines[0];
    }

    /*
     * Exception decompiling
     */
    public static String getStartPageName(IFile configFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IPath getRelativePath(IContainer container, IResource resource) {
        IPath resourcePath;
        if (resource == null) {
            return null;
        }
        if (container == null) {
            return resource.getFullPath();
        }
        IPath containerPath = container.getFullPath();
        if (containerPath.isPrefixOf(resourcePath = resource.getFullPath())) {
            int containerPathSegmentCount = containerPath.segmentCount();
            return resourcePath.removeFirstSegments(containerPathSegmentCount);
        }
        return null;
    }

    public static String getStartPageParameters(String StartPageName) {
        String parameterString = null;
        int indexOfQueryParameter = CordovaSimLaunchParametersUtil.getQueryIndex(StartPageName);
        if (indexOfQueryParameter > 0) {
            parameterString = StartPageName.substring(indexOfQueryParameter, StartPageName.length());
        }
        return parameterString;
    }

    private static int getQueryIndex(String homeUrl) {
        return homeUrl.indexOf("?");
    }
}

