/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views.locations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.event.AnalysisEvent;
import org.sonarlint.eclipse.core.internal.event.AnalysisListener;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.markers.ShowIssueFlowsMarkerResolver;
import org.sonarlint.eclipse.ui.internal.views.AbstractSonarWebView;

public class IssueLocationsView
extends ViewPart
implements ISelectionListener,
AnalysisListener {
    public static final String ID = "org.sonarlint.eclipse.ui.views.IssueLocationsView";
    private TreeViewer locationsViewer;
    private ToggleAnnotationsAction showAnnotationsAction;

    static List<FlowNode> toFlowNodes(List<MarkerUtils.ExtraPosition> positions) {
        ArrayList<FlowNode> result = new ArrayList<FlowNode>();
        int id = 1;
        for (MarkerUtils.ExtraPosition extraPosition : positions) {
            String childLabel = positions.size() > 1 ? String.valueOf(id) + ": " + IssueLocationsView.positionLabel(extraPosition.getMessage()) : IssueLocationsView.positionLabel(extraPosition.getMessage());
            result.add(new FlowNode(childLabel, extraPosition));
            ++id;
        }
        return result;
    }

    private static String positionLabel(String message) {
        return message != null ? message : "";
    }

    public void setInput(@Nullable IMarker sonarlintMarker) {
        ITextEditor editorFound;
        this.locationsViewer.setInput((Object)sonarlintMarker);
        if (sonarlintMarker != null && this.showAnnotationsAction.isChecked() && (editorFound = IssueLocationsView.findOpenEditorFor(sonarlintMarker)) != null) {
            ShowIssueFlowsMarkerResolver.showAnnotations(sonarlintMarker, editorFound);
        }
    }

    @CheckForNull
    private static ITextEditor findOpenEditorFor(IMarker sonarlintMarker) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IEditorPart editorPart;
                IEditorInput editorInput;
                IEditorReference editor = iEditorReferenceArray[n2];
                try {
                    editorInput = editor.getEditorInput();
                }
                catch (PartInitException e) {
                    SonarLintLogger.get().error("Unable to restore editor", (Throwable)e);
                    break block6;
                }
                if (editorInput instanceof IFileEditorInput && ((IFileEditorInput)editorInput).getFile().equals((Object)sonarlintMarker.getResource()) && (editorPart = editor.getEditor(false)) instanceof ITextEditor) {
                    return (ITextEditor)editorPart;
                }
            }
            ++n2;
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IMarker selectedMarker = AbstractSonarWebView.findSelectedSonarIssue(selection);
        if (selectedMarker != null && !Objects.equals(selectedMarker, this.locationsViewer.getInput())) {
            this.setInput(selectedMarker);
        }
    }

    private void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    private void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void createPartControl(Composite parent) {
        this.createToolbar();
        Tree tree = new Tree(parent, 2);
        this.locationsViewer = new TreeViewer(tree);
        this.locationsViewer.setAutoExpandLevel(-1);
        this.locationsViewer.setUseHashlookup(true);
        this.locationsViewer.setContentProvider((IContentProvider)new LocationsProvider());
        this.locationsViewer.setLabelProvider((IBaseLabelProvider)new LocationsTreeLabelProvider());
        this.locationsViewer.addPostSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement == null) {
                    return;
                }
                this.onTreeNodeSelected(firstElement);
            }
        });
        this.locationsViewer.addDoubleClickListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement == null) {
                    return;
                }
                this.onTreeNodeDoubleClick(firstElement);
            }
        });
        this.startListeningForSelectionChanges();
        SonarLintCorePlugin.getAnalysisListenerManager().addListener((AnalysisListener)this);
    }

    private void onTreeNodeSelected(Object node) {
        if (node instanceof FlowNode) {
            IMarker sonarlintMarker = (IMarker)this.locationsViewer.getInput();
            MarkerUtils.ExtraPosition pos = ((FlowNode)node).getPosition();
            ITextEditor openEditor = IssueLocationsView.findOpenEditorFor(sonarlintMarker);
            if (openEditor != null) {
                openEditor.setHighlightRange(pos.offset, pos.length, true);
            }
        }
    }

    private void onTreeNodeDoubleClick(Object node) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (node instanceof RootNode) {
                IDE.openEditor((IWorkbenchPage)page, (IMarker)((RootNode)node).getMarker());
            } else if (node instanceof FlowNode) {
                IMarker sonarlintMarker = (IMarker)this.locationsViewer.getInput();
                MarkerUtils.ExtraPosition pos = ((FlowNode)node).getPosition();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IMarker)sonarlintMarker);
                if (editor instanceof ITextEditor) {
                    ((ITextEditor)editor).selectAndReveal(pos.offset, pos.length);
                }
            }
        }
        catch (PartInitException e) {
            SonarLintLogger.get().error("Unable to open editor", (Throwable)e);
        }
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.showAnnotationsAction = new ToggleAnnotationsAction();
        toolbarManager.add((IAction)this.showAnnotationsAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.update(false);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.stopListeningForSelectionChanges();
        SonarLintCorePlugin.getAnalysisListenerManager().removeListener((AnalysisListener)this);
        ShowIssueFlowsMarkerResolver.removeAllAnnotations();
        super.dispose();
    }

    public void usedAnalysis(AnalysisEvent event) {
        IMarker marker = (IMarker)this.locationsViewer.getInput();
        Display.getDefault().asyncExec(() -> {
            if (marker != null && marker.exists()) {
                this.setInput(marker);
            } else {
                this.setInput(null);
            }
        });
    }

    public void showAnnotations() {
        ITextEditor editorFound;
        IMarker sonarlintMarker = (IMarker)this.locationsViewer.getInput();
        if (sonarlintMarker != null && (editorFound = IssueLocationsView.findOpenEditorFor(sonarlintMarker)) != null) {
            ShowIssueFlowsMarkerResolver.showAnnotations(sonarlintMarker, editorFound);
        }
    }

    public void setShowAnnotations(boolean b) {
        this.showAnnotationsAction.setChecked(b);
    }

    private static class FlowNode {
        private final String label;
        private final MarkerUtils.ExtraPosition position;

        public FlowNode(MarkerUtils.ExtraPosition position) {
            this(IssueLocationsView.positionLabel(position.getMessage()), position);
        }

        public FlowNode(String label, MarkerUtils.ExtraPosition position) {
            this.label = label;
            this.position = position;
        }

        public String getLabel() {
            return this.label;
        }

        public MarkerUtils.ExtraPosition getPosition() {
            return this.position;
        }
    }

    private static class FlowRootNode {
        private final String label;
        private final List<FlowNode> children;

        public FlowRootNode(String label, List<MarkerUtils.ExtraPosition> positions) {
            this.label = label;
            this.children = IssueLocationsView.toFlowNodes(positions);
        }

        public String getLabel() {
            return this.label;
        }

        public FlowNode[] getChildren() {
            return this.children.toArray(new FlowNode[0]);
        }
    }

    private static class LocationsProvider
    implements ITreeContentProvider {
        private LocationsProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IMarker sonarlintMarker = (IMarker)inputElement;
            try {
                if ("org.sonarlint.eclipse.core.sonarlintReportProblem".equals(sonarlintMarker.getType())) {
                    return new Object[]{"Information not available from the Report view"};
                }
            }
            catch (CoreException coreException) {}
            if (sonarlintMarker.getAttribute("hasextralocation", false)) {
                ITextEditor openEditor = IssueLocationsView.findOpenEditorFor(sonarlintMarker);
                if (openEditor == null) {
                    return new Object[]{"Please open the file containing this issue in an editor to see the flows"};
                }
                IDocument document = openEditor.getDocumentProvider().getDocument((Object)openEditor.getEditorInput());
                return new Object[]{new RootNode(sonarlintMarker, LocationsProvider.positions(document, p -> p.getMarkerId() == sonarlintMarker.getId()))};
            }
            return new Object[]{"No additional locations associated with this issue"};
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RootNode) {
                List<List<MarkerUtils.ExtraPosition>> flows = ((RootNode)parentElement).getFlows();
                if (flows.size() > 1) {
                    AtomicInteger counter = new AtomicInteger(0);
                    return flows.stream().map(f -> f.size() > 1 ? new FlowRootNode("Flow " + counter.incrementAndGet(), (List<MarkerUtils.ExtraPosition>)f) : new FlowNode((MarkerUtils.ExtraPosition)f.get(0))).toArray();
                }
                if (flows.size() == 1) {
                    return IssueLocationsView.toFlowNodes(flows.get(0)).toArray();
                }
                return new Object[0];
            }
            if (parentElement instanceof FlowRootNode) {
                return ((FlowRootNode)parentElement).getChildren();
            }
            return new Object[0];
        }

        private static List<MarkerUtils.ExtraPosition> positions(IDocument document, Predicate<? super MarkerUtils.ExtraPosition> filter) {
            try {
                return Arrays.asList(document.getPositions("sonarlintextralocations")).stream().map(p -> (MarkerUtils.ExtraPosition)p).filter(filter).collect(Collectors.toList());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                SonarLintLogger.get().debug("No extra positions found, should maybe trigger a new analysis");
                return Collections.emptyList();
            }
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class LocationsTreeLabelProvider
    extends LabelProvider {
        private LocationsTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof RootNode) {
                return ((RootNode)element).getMarker().getAttribute("message", "No message");
            }
            if (element instanceof FlowRootNode) {
                return ((FlowRootNode)element).getLabel();
            }
            if (element instanceof FlowNode) {
                return ((FlowNode)element).getLabel();
            }
            if (element instanceof String) {
                return (String)element;
            }
            throw new IllegalArgumentException("Unknow node type: " + element);
        }

        public Image getImage(Object element) {
            if (element instanceof RootNode) {
                return SonarLintImages.IMG_ISSUE;
            }
            return super.getImage(element);
        }
    }

    private static class RootNode {
        private final IMarker rootMarker;
        private final List<List<MarkerUtils.ExtraPosition>> flows;

        public RootNode(IMarker rootMarker, List<MarkerUtils.ExtraPosition> positions) {
            this.rootMarker = rootMarker;
            this.flows = RootNode.rebuildFlows(positions);
        }

        private static List<List<MarkerUtils.ExtraPosition>> rebuildFlows(List<MarkerUtils.ExtraPosition> positions) {
            ArrayList<List<MarkerUtils.ExtraPosition>> result = new ArrayList<List<MarkerUtils.ExtraPosition>>();
            List roots = positions.stream().filter(p -> p.getParent() == null).collect(Collectors.toList());
            for (MarkerUtils.ExtraPosition root : roots) {
                ArrayList<MarkerUtils.ExtraPosition> flow = new ArrayList<MarkerUtils.ExtraPosition>();
                Optional<MarkerUtils.ExtraPosition> current = Optional.of(root);
                while (current.isPresent()) {
                    MarkerUtils.ExtraPosition currentValue = current.get();
                    flow.add(currentValue);
                    current = positions.stream().filter(p -> p.getParent() == currentValue).findFirst();
                }
                result.add(flow);
            }
            return result;
        }

        public IMarker getMarker() {
            return this.rootMarker;
        }

        public List<List<MarkerUtils.ExtraPosition>> getFlows() {
            return this.flows;
        }
    }

    public class ToggleAnnotationsAction
    extends Action {
        public ToggleAnnotationsAction() {
            super("Toggle annotations");
            this.setDescription("Show/hide annotations in editor");
            this.setToolTipText("Show/hide annotations in editor");
            this.setImageDescriptor(SonarLintImages.MARK_OCCURENCES_IMG);
            this.setChecked(true);
        }

        public void run() {
            if (this.isChecked()) {
                IssueLocationsView.this.showAnnotations();
            } else {
                ShowIssueFlowsMarkerResolver.removeAllAnnotations();
            }
        }
    }
}

